/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.onemind.commons.java.util.FileUtils;
import org.onemind.jxp.CachedJxpPage;
import org.onemind.jxp.CachingPageSource;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageNotFoundException;
import org.onemind.jxp.JxpPageParseException;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.parser.AstJxpDocument;
import org.onemind.jxp.parser.JxpParser;
import org.onemind.jxp.parser.ParseException;

public class FilePageSource
extends CachingPageSource {
    private String _pathPrefix;

    public FilePageSource(String pathPrefix) {
        this._pathPrefix = pathPrefix;
    }

    public final String getStreamName(String pageName) {
        return FileUtils.concatFilePath(this.getPathPrefix(), pageName);
    }

    protected final CachedJxpPage loadJxpPage(String id) throws JxpPageNotFoundException {
        String filename = this.getStreamName(id);
        File f = new File(filename);
        if (f.exists()) {
            return new FileJxpPage(this, id, f);
        }
        throw new JxpPageNotFoundException("Page " + id + " not found");
    }

    public AstJxpDocument getJxpDocument(JxpPage page) throws JxpPageParseException {
        FileJxpPage fpage = (FileJxpPage)page;
        if (this.isCaching() && fpage.isExpired()) {
            fpage.setDocument(null);
        }
        return super.getJxpDocument(page);
    }

    public final AstJxpDocument parseJxpDocument(JxpPage page) throws JxpPageParseException {
        FileJxpPage filePage = (FileJxpPage)page;
        try {
            File f = filePage.getFile();
            FileInputStream fin = new FileInputStream(f);
            JxpParser parser = new JxpParser(fin);
            filePage.updateModTime();
            return parser.JxpDocument();
        }
        catch (ParseException e) {
            String message = "Problem parsing page " + page.getName() + ": " + e.getMessage();
            throw new JxpPageParseException(message, e);
        }
        catch (IOException e) {
            throw new JxpPageParseException("Problem parseing page " + page.getName() + ": " + e.getMessage(), e);
        }
    }

    public final String getPathPrefix() {
        return this._pathPrefix;
    }

    public final void setPathPrefix(String pathPrefix) {
        this._pathPrefix = pathPrefix;
    }

    public final boolean hasJxpPage(String id) {
        if (this.isJxpPageCached(id)) {
            return true;
        }
        String filename = this.getStreamName(id);
        File f = new File(filename);
        return f.exists();
    }

    private final class FileJxpPage
    extends CachedJxpPage {
        private File _file;
        private long _modTime;

        public FileJxpPage(JxpPageSource source, String name, File file) {
            super(source, name);
            this.setFile(file);
            this._modTime = file.lastModified();
        }

        public final long getModTime() {
            return this._modTime;
        }

        public final File getFile() {
            return this._file;
        }

        public final void setFile(File file) {
            this._file = file;
        }

        protected final boolean isExpired() {
            return new File(this._file.getAbsolutePath()).lastModified() > this.getModTime();
        }

        public void updateModTime() {
            this._modTime = this._file.lastModified();
        }
    }
}

