/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.onemind.commons.invoke.AbstractInvocable;
import org.onemind.commons.java.datastructure.NametableStack;
import org.onemind.commons.java.lang.reflect.ClassLookupCache;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.util.StaticImport;

public class JxpProcessingContext
extends AbstractInvocable {
    private static final Logger _logger = Logger.getLogger((class$org$onemind$jxp$JxpProcessingContext == null ? (class$org$onemind$jxp$JxpProcessingContext = JxpProcessingContext.class$("org.onemind.jxp.JxpProcessingContext")) : class$org$onemind$jxp$JxpProcessingContext).getName());
    private static final ClassLookupCache _default_imports = new ClassLookupCache();
    private ClassLookupCache _imports = new ClassLookupCache();
    private Writer _writer;
    private Stack _pageStack = new Stack();
    private Stack _ntStack = new Stack();
    private JxpPage _currentPage;
    private NametableStack _currentNametableStack;
    private Map _userDefinedFunctions = new HashMap();
    private List _staticImports = new ArrayList();
    static /* synthetic */ Class class$org$onemind$jxp$JxpProcessingContext;

    public JxpProcessingContext(Writer writer, Map env) {
        this._writer = writer;
        env.put("jxp_writer", this._writer);
        env.put("jxp_context", this);
        this.pushNametableStack(new NametableStack(env));
    }

    public final void pushPage(JxpPage page) {
        this._currentPage = page;
        this._pageStack.push(page);
        this._currentNametableStack.put("jxp_script_name", page.getName());
    }

    public final JxpPage getCurrentPage() {
        return this._currentPage;
    }

    public final void popPage(JxpPage page) throws IllegalStateException {
        if (this._pageStack.peek() != page) {
            throw new IllegalStateException("Popping wrong page " + page);
        }
        this._pageStack.pop();
        this._currentPage = this._pageStack.size() != 0 ? (JxpPage)this._pageStack.peek() : null;
        this._currentNametableStack.put("jxp_script_name", page.getName());
    }

    protected final Class resolveClass(String className) {
        Class c;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Resolving " + className);
        }
        if ((c = _default_imports.getClass(className)) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Resolving " + className + " package " + this._imports.getPackages());
            }
            c = this._imports.getClass(className);
        }
        return c;
    }

    public final void pushNametableStack(NametableStack stack) {
        this._currentNametableStack = stack;
        this._ntStack.push(stack);
    }

    public final NametableStack getNametableStack() {
        return this._currentNametableStack;
    }

    public final void popNametableStack() {
        this._ntStack.pop();
        if (this._ntStack.size() > 0) {
            this._currentNametableStack = (NametableStack)this._ntStack.peek();
        }
    }

    public final ClassLookupCache getImports() {
        return this._imports;
    }

    public final Writer getWriter() {
        return this._writer;
    }

    public final Map getUserDefinedFunctions() {
        return this._userDefinedFunctions;
    }

    public void addStaticImport(StaticImport sImport) {
        this._staticImports.add(sImport);
    }

    public final List getStaticImports() {
        return this._staticImports;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _default_imports.addPackage("java.lang");
        _default_imports.addPackage("java.util");
    }
}

