/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.MSExportConstants;

public class PriorityMappingPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_VALUE = 1000;
    private static final int MIN_VALUE = 0;
    private static final int INCREAMENT = 20;
    private List<Spinner> spinners = null;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AsposePlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        body.setLayout((Layout)gridLayout);
        this.createDescription(body);
        this.createMappings(body);
        return body;
    }

    private void createMappings(Composite parent) {
        if (this.spinners == null) {
            this.spinners = new ArrayList<Spinner>();
        }
        int i = 0;
        while (i < 9) {
            Label label = new Label(parent, 0x1000000);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            Image image = null;
            try {
                image = new Image(null, Platform.getBundle((String)"org.xmind.ui.aspose").getEntry("icons/priority_" + (i + 1) + ".png").openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            label.setImage(image);
            Spinner spinner = new Spinner(parent, 2048);
            spinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            this.setSpinnerValues(spinner, i);
            spinner.setRedraw(true);
            spinner.setVisible(true);
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PriorityMappingPrefPage.this.checkPriorityMap();
                }
            });
            spinner.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PriorityMappingPrefPage.this.checkPriorityMap();
                }

                public void focusGained(FocusEvent e) {
                    PriorityMappingPrefPage.this.checkPriorityMap();
                }
            });
            this.spinners.add(spinner);
            ++i;
        }
        Label default_priority = new Label(parent, 0x1000000);
        default_priority.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        default_priority.setText(ExportMessages.Default_Priority);
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.setSpinnerValues(spinner, 9);
        spinner.setVisible(true);
        this.spinners.add(spinner);
    }

    private void createDescription(Composite parent) {
        Label descriptionLabel = new Label(parent, 0);
        descriptionLabel.setLayoutData((Object)new GridData(1, 128, false, false, 2, 2));
        descriptionLabel.setText(ExportMessages.PriorityPage_Text);
        Label xmindLabel = new Label(parent, 0x1000000);
        xmindLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        xmindLabel.setText(ExportMessages.XMind_Priority_Text);
        Label msprojectLabel = new Label(parent, 0x1000000);
        msprojectLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        msprojectLabel.setText(ExportMessages.MSProject_Priority_Text);
        int i = 0;
        while (i < 2) {
            Label left = new Label(parent, 0x1000000);
            left.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
            left.setText("______________");
            ++i;
        }
    }

    private void checkPriorityMap() {
        if (this.isAllPriorityValid()) {
            this.setMessage(ExportMessages.Priority_warningMessage, 2);
        } else {
            this.setMessage(null);
        }
    }

    private boolean isAllPriorityValid() {
        int i = 0;
        while (i < 8) {
            if (this.comparePriority(this.spinners.get(i), this.spinners.get(i + 1))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean comparePriority(Spinner preSpinner, Spinner nextSpinner) {
        return preSpinner.getSelection() <= nextSpinner.getSelection();
    }

    private void setSpinnerValues(Spinner spinner, int i) {
        spinner.setMinimum(0);
        spinner.setMaximum(1000);
        spinner.setIncrement(20);
        if (!this.doGetPreferenceStore().contains("org.xmind.ui.aspose.exports.project.priority9")) {
            this.initPriorityMap();
            this.setDefaultSpinner(spinner, i);
        } else {
            spinner.setSelection(this.doGetPreferenceStore().getInt("org.xmind.ui.aspose.exports.project.priority" + i));
        }
    }

    private void setDefaultSpinner(Spinner spinner, int i) {
        if (9 == i) {
            spinner.setSelection(500);
        } else {
            spinner.setSelection(MSExportConstants.DEFAULT_PRIORITYS[i]);
        }
    }

    private void initPriorityMap() {
        int i = 0;
        while (i < 9) {
            this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority" + i, MSExportConstants.DEFAULT_PRIORITYS[i]);
            ++i;
        }
        this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority9", 500);
    }

    public boolean performOk() {
        this.saveChange();
        return super.performOk();
    }

    private void saveChange() {
        int i = 0;
        while (i < 10) {
            this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority" + i, this.spinners.get(i).getSelection());
            ++i;
        }
    }

    protected void performDefaults() {
        this.initPriorityMap();
        this.updataSpinnerView();
        super.performDefaults();
    }

    private void updataSpinnerView() {
        int i = 0;
        while (i < 10) {
            this.spinners.get(i).setSelection(this.doGetPreferenceStore().getInt("org.xmind.ui.aspose.exports.project.priority" + i));
            ++i;
        }
    }
}

