/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.slide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.Core;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.NullGraphicalPart;
import org.xmind.gef.tool.BrowsingTool;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.ContentPanePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.internal.aspose.exports.MSExportWizardPage;
import org.xmind.ui.internal.mindmap.ViewerModel;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.IViewerModel;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.resources.ImageUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.ExportUtils;

public class PPTExportPageBase
extends MSExportWizardPage {
    private static final Dimension SLIDE_SIZE = new Dimension(160, 120);

    public PPTExportPageBase(String pageName, String title) {
        super(pageName, title);
    }

    protected void initPreviewViewer(IGraphicalViewer previewViewer) {
        previewViewer.setPartFactory((IPartFactory)new PPTPreviewPartFactory(previewViewer.getPartFactory()));
        Properties properties = previewViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().margins(0).spacing(0, 0));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)SLIDE_SIZE);
        EditDomain domain = new EditDomain();
        domain.installTool("browse tool", (ITool)new BrowsingTool());
        previewViewer.setEditDomain(domain);
    }

    protected ISheet createSampleSheet() {
        IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook();
        workbook.getMarkerSheet().setParentSheet(MindMapUI.getResourceManager().getSystemMarkerSheet());
        ISheet sheet = workbook.getPrimarySheet();
        ITopic rootTopic = sheet.getRootTopic();
        rootTopic.setTitleText(WizardMessages.DocumentExportPage_Sample_CentralTopic);
        rootTopic.addMarker("smiley-smile");
        rootTopic.addLabel(WizardMessages.DocumentExportPage_Sample_Label1);
        ITopic mainTopic = workbook.createTopic();
        rootTopic.add(mainTopic);
        mainTopic.setTitleText(WizardMessages.DocumentExportPage_Sample_MainTopic1);
        mainTopic.addMarker("priority-1");
        mainTopic.addMarker("smiley-smile");
        mainTopic.setLabels(Arrays.asList(WizardMessages.DocumentExportPage_Sample_Label1, WizardMessages.DocumentExportPage_Sample_Label2));
        mainTopic.setHyperlink("http://www.xmind.org");
        mainTopic.getImage().setSource("temp.png");
        INotesContent notesContent = workbook.createNotesContent("plain");
        ((IPlainNotesContent)notesContent).setTextContent(this.getSampleNotes());
        mainTopic.getNotes().setContent("plain", notesContent);
        ITopic sub1 = workbook.createTopic();
        sub1.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic1);
        mainTopic.add(sub1);
        ITopic sub2 = workbook.createTopic();
        sub2.setTitleText(WizardMessages.DocumentExportPage_Sample_Subtopic2);
        mainTopic.add(sub2);
        ITopic summary1 = workbook.createTopic();
        summary1.setTitleText(WizardMessages.DocumentExportPage_Sample_Summary1);
        mainTopic.add(summary1, "summary");
        ITopic floating1 = workbook.createTopic();
        floating1.setTitleText(WizardMessages.DocumentExportPage_Sample_FloatingTopic1);
        rootTopic.add(floating1, "detached");
        return sheet;
    }

    protected void createAdditionalWidgets(Composite parent) {
        this.createAllCheck(parent);
        this.createBooleanWidget(parent, "includeHyperlink");
        this.createBooleanWidget(parent, "includeMarkers");
        this.createBooleanWidget(parent, "includeLabels");
        this.createBooleanWidget(parent, "includeImage");
        this.createBooleanWidget(parent, "includeNotes");
        this.createBooleanWidget(parent, "includeSummaries");
        this.createBooleanWidget(parent, "includeFloatingTopics");
        this.endAllCheckCreation();
    }

    protected void createPreviewViewer(Composite parent) {
        super.createPreviewViewer(parent);
        GridData data = (GridData)parent.getLayoutData();
        data.heightHint = 280;
        data.widthHint = 200;
    }

    protected class ContentsPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            figure.setBorder((Border)new MarginBorder(5));
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(false);
            layout.setMajorAlignment(1);
            layout.setMinorAlignment(1);
            layout.setSpacing(0);
            return layout;
        }

        protected Object[] getModelChildren(Object model) {
            List children = this.getTopic().getChildren("attached");
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>(children.size());
            for (ITopic sub : children) {
                list.add(new ViewerModel(SubtopicTitlePreviewPart.class, (Object)sub));
            }
            return list.toArray();
        }
    }

    protected class ContentsSlidePart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            return new NormalPageLayout();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            figure.setBorder((Border)new MarginBorder(5));
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeOverview", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("separateOverview", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("separateOverview", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeOverview", (IPart)this);
            super.uninstallModelListeners();
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>(2);
            ITopic topic = this.getTopic();
            list.add(new ViewerModel(TitlePreviewPart.class, (Object)topic));
            if (PPTExportPageBase.this.getBoolean("includeOverview") && topic.hasChildren("attached") && (topic.isRoot() || PPTExportPageBase.this.getBoolean("separateOverview"))) {
                list.add(new ViewerModel(OverviewPreviewPart.class, (Object)topic));
            } else {
                list.add(new ViewerModel(ContentsPreviewPart.class, (Object)topic));
            }
            return list.toArray();
        }
    }

    protected class ImagePreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new SizeableImageFigure();
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            layout.setMajorAlignment(1);
            return layout;
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            SizeableImageFigure imgFigure = (SizeableImageFigure)figure;
            Image image = ImageUtils.getImage((ImageDescriptor)MindMapUI.getImages().get("insertimage.png", true));
            imgFigure.setImage(image);
            imgFigure.setPreferredSize(imgFigure.getImageSize());
        }
    }

    protected class MainTitleSlidePart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            return new TitlePageLayout();
        }

        public ITopic getCentralTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            super.uninstallModelListeners();
        }

        protected Object[] getModelChildren(Object model) {
            ITopic topic = this.getCentralTopic();
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>(2);
            list.add(new ViewerModel(TitlePreviewPart.class, (Object)topic));
            if (!topic.getMarkerRefs().isEmpty() && PPTExportPageBase.this.getBoolean("includeMarkers") || !topic.getLabels().isEmpty() && PPTExportPageBase.this.getBoolean("includeLabels")) {
                list.add(new ViewerModel(TagsPreviewPart.class, (Object)topic));
            }
            return list.toArray();
        }
    }

    private static class NormalPageLayout
    extends AbstractLayout {
        private NormalPageLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return SLIDE_SIZE;
        }

        public void layout(IFigure container) {
            if (container.getChildren().size() > 0) {
                IFigure title = (IFigure)container.getChildren().get(0);
                Rectangle clientArea = container.getClientArea();
                Dimension titleSize = title.getPreferredSize(clientArea.width, -1);
                Rectangle titleBounds = Rectangle.SINGLETON.setLocation(clientArea.x, clientArea.y + 5).setSize(clientArea.width, titleSize.height);
                title.setBounds(titleBounds);
                if (container.getChildren().size() > 1) {
                    IFigure content = (IFigure)container.getChildren().get(1);
                    Dimension contentSize = content.getPreferredSize(clientArea.width, -1);
                    content.setBounds(Rectangle.SINGLETON.setLocation(clientArea.x, titleBounds.bottom() + 3).setSize(clientArea.width, contentSize.height));
                }
                if (container.getChildren().size() > 2) {
                    IFigure image = (IFigure)container.getChildren().get(2);
                    Dimension imageSize = image.getPreferredSize();
                    image.setBounds(Rectangle.SINGLETON.setLocation(clientArea.x + (clientArea.width - imageSize.width) / 2, clientArea.y + clientArea.height * 5 / 8 - imageSize.height / 2).setSize(imageSize));
                }
            }
        }
    }

    protected class NotesPreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new RotatableWrapLabel(0);
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            RotatableWrapLabel label = (RotatableWrapLabel)figure;
            label.setTextAlignment(1);
            label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)4));
            label.setForegroundColor(ColorConstants.darkGray);
            label.setText(((IPlainNotesContent)this.getTopic().getNotes().getContent("plain")).getTextContent());
        }
    }

    protected class NotesSlidePart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            figure.setBorder((Border)new MarginBorder(5));
        }

        protected LayoutManager createLayoutManager() {
            return new NormalPageLayout();
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>(2);
            ITopic topic = this.getTopic();
            list.add(new ViewerModel(TitlePreviewPart.class, (Object)topic));
            list.add(new ViewerModel(NotesPreviewPart.class, (Object)topic));
            return list.toArray();
        }
    }

    protected class OverviewPreviewPart
    extends GraphicalEditPart {
        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new SizeableImageFigure();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            LineBorder border1 = new LineBorder(ColorConstants.lightGray, 1);
            MarginBorder border2 = new MarginBorder(3);
            figure.setBorder((Border)new CompoundBorder((Border)border2, (Border)border1));
            ((SizeableImageFigure)figure).setConstrained(true);
            ((SizeableImageFigure)figure).setStretched(true);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeOverview", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("separateOverview", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("separateOverview", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeOverview", (IPart)this);
            super.uninstallModelListeners();
        }

        protected void updateView() {
            super.updateView();
            SizeableImageFigure imgFigure = (SizeableImageFigure)this.getFigure();
            if (this.getTopic().isRoot()) {
                if (PPTExportPageBase.this.getBoolean("separateOverview")) {
                    imgFigure.setImage(PPTExportPageBase.this.getOverviewImage("icons/misc/overview_preview2.png"));
                } else {
                    imgFigure.setImage(PPTExportPageBase.this.getOverviewImage("icons/misc/overview_preview.png"));
                }
            } else {
                imgFigure.setImage(PPTExportPageBase.this.getOverviewImage("icons/misc/overview_preview3.png"));
            }
            imgFigure.setPreferredSize(100, 80);
        }
    }

    private class PPTContantPanePart
    extends ContentPanePart {
        public PPTContantPanePart(ISheet input) {
            super((Object)input);
        }

        protected Object[] getModelChildren(Object model) {
            boolean showNotes;
            ArrayList<ViewerModel> list = new ArrayList<ViewerModel>();
            ISheet sheet = (ISheet)this.getModel();
            ITopic rootTopic = sheet.getRootTopic();
            list.add(new ViewerModel(MainTitleSlidePart.class, (Object)rootTopic));
            list.add(new ViewerModel(ContentsSlidePart.class, (Object)rootTopic));
            ITopic mainTopic = (ITopic)rootTopic.getChildren("attached").get(0);
            boolean showMarker = PPTExportPageBase.this.getBoolean("includeMarkers");
            boolean showLabel = PPTExportPageBase.this.getBoolean("includeLabels");
            boolean showImage = PPTExportPageBase.this.getBoolean("includeImage");
            if (showMarker || showLabel || showImage) {
                list.add(new ViewerModel(TopicTitleSlidePart.class, (Object)mainTopic));
            }
            if (showNotes = PPTExportPageBase.this.getBoolean("includeNotes")) {
                list.add(new ViewerModel(NotesSlidePart.class, (Object)mainTopic));
            }
            list.add(new ViewerModel(ContentsSlidePart.class, (Object)mainTopic));
            for (ITopic sub : mainTopic.getChildren("attached")) {
                list.add(new ViewerModel(ContentsSlidePart.class, (Object)sub));
            }
            if (PPTExportPageBase.this.getBoolean("includeSummaries")) {
                for (ITopic t : mainTopic.getChildren("summary")) {
                    list.add(new ViewerModel(ContentsSlidePart.class, (Object)t));
                }
            }
            if (PPTExportPageBase.this.getBoolean("includeFloatingTopics")) {
                for (ITopic t : rootTopic.getChildren("detached")) {
                    list.add(new ViewerModel(ContentsSlidePart.class, (Object)t));
                }
            }
            return list.toArray();
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeFloatingTopics", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeImage", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeNotes", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeOverview", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeRelationships", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeSummaries", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("includeFloatingTopics", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeImage", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeNotes", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeOverview", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeRelationships", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeSummaries", (IPart)this);
            super.uninstallModelListeners();
        }
    }

    protected class PPTPreviewPartFactory
    implements IPartFactory {
        private IPartFactory factory;

        public PPTPreviewPartFactory(IPartFactory factory) {
            this.factory = factory;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof ContentPanePart) {
                return this.factory.createPart(context, model);
            }
            if (model instanceof ISheet) {
                return new PPTContantPanePart((ISheet)model);
            }
            if (model instanceof IViewerModel) {
                IViewerModel m = (IViewerModel)model;
                try {
                    IPart part = (IPart)m.getPartType().getConstructors()[0].newInstance(new Object[]{PPTExportPageBase.this});
                    part.setModel(model);
                    return part;
                }
                catch (Throwable e) {
                    Logger.log((Throwable)e, (String)("Failed to create export preview part: " + m.getPartType()));
                }
            }
            return new NullGraphicalPart();
        }
    }

    protected class SubtopicTitlePreviewPart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected LayoutManager createLayoutManager() {
            AdvancedToolbarLayout layout = new AdvancedToolbarLayout(true);
            layout.setMajorAlignment(1);
            layout.setMinorAlignment(0);
            layout.setSpacing(5);
            return layout;
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            Ellipse dot = new Ellipse();
            dot.setBackgroundColor(ColorConstants.gray);
            dot.setForegroundColor(ColorConstants.gray);
            dot.setFill(true);
            dot.setOutline(true);
            dot.setSize(5, 5);
            figure.add((IFigure)dot);
            RotatableWrapLabel label = new RotatableWrapLabel(0);
            ITopic topic = this.getTopic();
            String title = topic.getTitleText();
            String num = ExportUtils.getNumberingText((ITopic)topic, null);
            if (num != null) {
                title = String.valueOf(num) + " " + title;
            }
            label.setText(title);
            label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
            label.setForegroundColor(ColorConstants.black);
            figure.add((IFigure)label);
        }
    }

    protected class TagsPreviewPart
    extends GraphicalEditPart {
        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new RotatableWrapLabel(0);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            super.uninstallModelListeners();
        }

        protected void updateView() {
            boolean hasLabel;
            super.updateView();
            RotatableWrapLabel label = (RotatableWrapLabel)this.getFigure();
            label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)6));
            label.setTextAlignment(2);
            StringBuilder sb = new StringBuilder();
            boolean hasMarker = false;
            if (PPTExportPageBase.this.getBoolean("includeMarkers")) {
                Iterator it = this.getTopic().getMarkerRefs().iterator();
                while (it.hasNext()) {
                    hasMarker = true;
                    IMarkerRef mr = (IMarkerRef)it.next();
                    String markerId = mr.getMarkerId();
                    String name = this.getTopic().getOwnedSheet().getLegend().getMarkerDescription(markerId);
                    sb.append(name);
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
            boolean bl = hasLabel = PPTExportPageBase.this.getBoolean("includeLabels") && !this.getTopic().getLabels().isEmpty();
            if (hasLabel && hasMarker) {
                sb.append(", ");
            }
            if (hasLabel) {
                Iterator it = this.getTopic().getLabels().iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
            label.setText(sb.toString());
        }
    }

    private static class TitlePageLayout
    extends AbstractLayout {
        private TitlePageLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return SLIDE_SIZE;
        }

        public void layout(IFigure container) {
            if (container.getChildren().size() > 0) {
                IFigure title = (IFigure)container.getChildren().get(0);
                Rectangle clientArea = container.getClientArea();
                Dimension titleSize = title.getPreferredSize(clientArea.width, -1);
                Rectangle titleBounds = Rectangle.SINGLETON.setLocation(clientArea.x, clientArea.y + clientArea.height / 2 - titleSize.height * 3 / 4).setSize(clientArea.width, titleSize.height);
                title.setBounds(titleBounds);
                if (container.getChildren().size() > 1) {
                    IFigure subTitle = (IFigure)container.getChildren().get(1);
                    Dimension tagsSize = subTitle.getPreferredSize(clientArea.width, -1);
                    Rectangle tagsBounds = Rectangle.SINGLETON.setLocation(clientArea.x, titleBounds.bottom() + 5).setSize(clientArea.width, tagsSize.height);
                    subTitle.setBounds(tagsBounds);
                }
            }
        }
    }

    protected class TitlePreviewPart
    extends GraphicalEditPart {
        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected IFigure createFigure() {
            return new RotatableWrapLabel(0);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeHyperlink", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("includeHyperlink", (IPart)this);
            super.uninstallModelListeners();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            ITopic topic = this.getTopic();
            int level = MindMapUtils.getLevel((ITopic)this.getTopic(), null);
            level = Math.min(2, level);
            Font font = FontUtils.getBold((String)"org.eclipse.jface.defaultfont");
            String titleText = topic.getTitleText();
            String num = ExportUtils.getNumberingText((ITopic)topic, null);
            if (num != null) {
                titleText = String.valueOf(num) + " " + titleText;
            }
            RotatableWrapLabel title = (RotatableWrapLabel)figure;
            title.setFont(font);
            title.setForegroundColor(ColorConstants.black);
            title.setText(titleText);
            title.setTextAlignment(2);
        }

        protected void updateView() {
            super.updateView();
            RotatableWrapLabel label = (RotatableWrapLabel)this.getFigure();
            TextStyle style = new TextStyle();
            style.font = label.getFont();
            if (PPTExportPageBase.this.getBoolean("includeHyperlink") && this.getTopic().getHyperlink() != null) {
                style.foreground = ColorConstants.blue;
                style.underline = true;
            } else {
                style.foreground = ColorConstants.black;
                style.underline = false;
            }
            label.setStyle(style);
        }
    }

    protected class TopicTitleSlidePart
    extends GraphicalEditPart {
        protected IFigure createFigure() {
            return new Figure();
        }

        protected void initFigure(IFigure figure) {
            super.initFigure(figure);
            figure.setBorder((Border)new MarginBorder(5));
        }

        protected LayoutManager createLayoutManager() {
            return new NormalPageLayout();
        }

        public ITopic getTopic() {
            return (ITopic)MindMapUtils.getRealModel((IPart)this);
        }

        protected void installModelListeners() {
            super.installModelListeners();
            PPTExportPageBase.this.addPropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeLabels", (IPart)this);
            PPTExportPageBase.this.addPropertyListener("includeImage", (IPart)this);
        }

        protected void uninstallModelListeners() {
            PPTExportPageBase.this.removePropertyListener("includeImage", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeMarkers", (IPart)this);
            PPTExportPageBase.this.removePropertyListener("includeLabels", (IPart)this);
            super.uninstallModelListeners();
        }

        protected Object[] getModelChildren(Object model) {
            ArrayList<Object> list = new ArrayList<Object>(3);
            ITopic topic = this.getTopic();
            list.add(new ViewerModel(TitlePreviewPart.class, (Object)topic));
            if (!topic.getMarkerRefs().isEmpty() && PPTExportPageBase.this.getBoolean("includeMarkers") || !topic.getLabels().isEmpty() && PPTExportPageBase.this.getBoolean("includeLabels")) {
                list.add(new ViewerModel(TagsPreviewPart.class, (Object)topic));
            } else {
                list.add(topic);
            }
            if (topic.getImage().getSource() != null && PPTExportPageBase.this.getBoolean("includeImage")) {
                list.add(new ViewerModel(ImagePreviewPart.class, (Object)topic));
            }
            return list.toArray();
        }
    }
}

