/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.xmind.core.command.remote.IRemoteCommandService;
import org.xmind.core.internal.sharing.AbstractSharedMap;
import org.xmind.core.sharing.IRemoteSharedLibrary;
import org.xmind.core.sharing.ISharedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSharedLibrary
implements IRemoteSharedLibrary {
    private IRemoteCommandService remoteService;
    private String name;
    private String contactID;
    private List<ISharedMap> maps = new ArrayList<ISharedMap>();

    public RemoteSharedLibrary(IRemoteCommandService remoteService, String name) {
        this.remoteService = remoteService;
        this.name = name;
    }

    public void addMaps(Collection<ISharedMap> maps) {
        this.maps.addAll(maps);
        Collections.sort(this.maps, AbstractSharedMap.MAP_COMPARATOR);
    }

    @Override
    public boolean hasMaps() {
        return !this.maps.isEmpty();
    }

    @Override
    public int getMapCount() {
        return this.maps.size();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRemoteCommandService.class) {
            return this.remoteService;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String getSymbolicName() {
        return this.remoteService.getInfo().getId().getName();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getContactID() {
        return this.contactID;
    }

    public void setContactID(String contactID) {
        this.contactID = contactID;
    }

    @Override
    public ISharedMap[] getMaps() {
        return this.maps.toArray(new ISharedMap[this.maps.size()]);
    }

    public IRemoteCommandService getRemoteCommandService() {
        return this.remoteService;
    }

    public void addMap(ISharedMap map) {
        this.maps.add(map);
        Collections.sort(this.maps, AbstractSharedMap.MAP_COMPARATOR);
    }

    public void removeMap(ISharedMap map) {
        this.maps.remove(map);
    }

    @Override
    public ISharedMap findMapByID(String id) {
        if (id != null) {
            for (ISharedMap map : this.maps) {
                if (!id.equals(map.getID())) continue;
                return map;
            }
        }
        return null;
    }

    @Override
    public void sortMaps(Comparator<ISharedMap> c) {
        Collections.sort(this.maps, c);
    }
}

