/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.util.ArrayList;
import java.util.List;
import org.xmind.ui.internal.iconfinder.model.SearchIconSession;

public class IconSessionManager {
    private List<SearchIconSession> searchIconSessions;
    private int index = -1;
    private boolean onSearch = false;

    public void addSession(SearchIconSession session) {
        if (this.searchIconSessions == null) {
            this.searchIconSessions = new ArrayList<SearchIconSession>();
        } else if (this.index != this.searchIconSessions.size() - 1) {
            this.searchIconSessions = IconSessionManager.copySubList(this.searchIconSessions, 0, this.index + 1);
        }
        this.searchIconSessions.add(session);
        ++this.index;
    }

    public SearchIconSession backward() {
        if (!this.hasPrevious()) {
            throw new RuntimeException("Iconfinder Bound error");
        }
        --this.index;
        SearchIconSession session = this.searchIconSessions.get(this.index);
        return session;
    }

    public SearchIconSession forward() {
        if (!this.hasNext()) {
            throw new RuntimeException("Iconfinder Bound error");
        }
        ++this.index;
        SearchIconSession session = this.searchIconSessions.get(this.index);
        return session;
    }

    public boolean hasPrevious() {
        return this.searchIconSessions != null && this.index > 0;
    }

    public boolean hasNext() {
        return this.searchIconSessions != null && this.index < this.searchIconSessions.size() - 1;
    }

    public void removeCurrentSession() {
        if (this.searchIconSessions == null || this.searchIconSessions.isEmpty()) {
            return;
        }
        this.searchIconSessions.remove(this.index);
        --this.index;
    }

    public boolean isOnSearch() {
        return this.onSearch;
    }

    public void setOnSearch(boolean onSearch) {
        this.onSearch = onSearch;
    }

    public SearchIconSession getCurrentSession() {
        if (this.searchIconSessions != null && !this.searchIconSessions.isEmpty()) {
            return this.searchIconSessions.get(this.index);
        }
        return null;
    }

    private static List<SearchIconSession> copySubList(List<SearchIconSession> source, int from, int to) {
        ArrayList<SearchIconSession> list = new ArrayList<SearchIconSession>();
        int i = from;
        while (i < to) {
            list.add(source.get(i));
            ++i;
        }
        return list;
    }
}

