/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.SWTUtils;

public class LicenseKeyInputDialog
extends Dialog {
    private static final String ICON_VALID = "icons/valid.png";
    private static final int CLEAR_ID = 1024;
    public static final int CLEARED = 1024;
    private Properties data;
    private int requiredStatus;
    private IStatus validity;
    private boolean sheet;
    private boolean showClear;
    private String errorMessage = null;
    private Composite messageArea;
    private Composite errorMessageArea;
    private Label errorLabel;
    private static String __PLACEHOLDER_TEXT__ = null;

    public LicenseKeyInputDialog(Shell parentShell, Properties data, int requiredStatus, IStatus validity, boolean sheet, boolean showClear) {
        super(parentShell);
        Assert.isNotNull((Object)data);
        this.data = data;
        this.validity = validity;
        this.requiredStatus = requiredStatus;
        this.sheet = sheet;
        this.showClear = showClear;
        if (sheet) {
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }

    public Properties getData() {
        return this.data;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorLabel == null || this.errorLabel.isDisposed()) {
            return;
        }
        Composite stack = this.messageArea.getParent();
        StackLayout layout = (StackLayout)stack.getLayout();
        if (errorMessage == null) {
            layout.topControl = this.messageArea;
            this.messageArea.setVisible(true);
            this.errorMessageArea.setVisible(false);
        } else {
            this.errorLabel.setText(errorMessage);
            layout.topControl = this.errorMessageArea;
            this.messageArea.setVisible(false);
            this.errorMessageArea.setVisible(true);
        }
        stack.layout();
    }

    private String getDialogMessage() {
        String plan;
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)brandingVersion);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)brandingVersion);
        } else {
            String plan2 = "Pro/Plus";
            return NLS.bind((String)Messages.LicenseKeyInputDialog_DialogMessage, (Object)plan2, (Object)brandingVersion);
        }
        return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)plan, (Object)(this.getLicenseTo() == null ? Messages.LicenseInputDialog_UnknownLicensee : this.getLicenseTo()));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.sheet) {
            newShell.setText(this.getParentShell().getText());
        } else {
            newShell.setText(Messages.LicenseInputDialog_windowTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createInputs(composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtonStatus();
        return contents;
    }

    private void createMessageArea(Composite parent) {
        Composite messageStack = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        messageStack.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 480;
        gridData.heightHint = -1;
        messageStack.setLayoutData((Object)gridData);
        if (this.showClear) {
            messageStack.setBackground(parent.getDisplay().getSystemColor(29));
        } else {
            messageStack.setBackground(parent.getDisplay().getSystemColor(25));
        }
        this.messageArea = this.createMessagePage(messageStack);
        this.messageArea.setBackground(messageStack.getBackground());
        this.createMessageIcon(this.messageArea, 2);
        this.createMessageLabel(this.messageArea, this.getDialogMessage());
        this.errorMessageArea = this.createMessagePage(messageStack);
        this.createMessageIcon(this.errorMessageArea, 8);
        this.errorLabel = this.createMessageLabel(this.errorMessageArea, this.errorMessage);
        this.setErrorMessage(this.errorMessage);
    }

    private Composite createMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 15;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        return composite;
    }

    private Label createMessageIcon(Composite parent, int image) {
        Label icon = new Label(parent, 0);
        GridData gridData = new GridData(1, 0x1000000, false, true);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        icon.setLayoutData((Object)gridData);
        icon.setBackground(parent.getBackground());
        this.setImage(icon, parent);
        return icon;
    }

    private Label createMessageLabel(Composite parent, String message) {
        Label label = new Label(parent, 64);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        label.setLayoutData((Object)gridData);
        label.setBackground(parent.getBackground());
        label.setForeground(parent.getDisplay().getSystemColor(24));
        label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        if (message != null) {
            label.setText(message);
        }
        return label;
    }

    private void createInputs(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputLabel(composite, Messages.LicenseKeyInputDialog_License_label);
        this.createInput(composite, "TimeSmilesInMyHand", false, -1, -1);
        this.createInputLabel(composite, Messages.LicenseKeyInputDialog_LicenseKey_label);
        this.createInput(composite, "WalkingInTheMorning", true, 130, 12);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int calcFontSize(int defaultFontSize, int maxWidth, int maxHeight) {
        int fontSize = defaultFontSize;
        GC gc = new GC((Drawable)this.getShell());
        try {
            block7: {
                Point size;
                block6: {
                    size = null;
                    if (!true) break block6;
                    if (size != null) return fontSize;
                    if (fontSize <= 0) break block7;
                }
                do {
                    gc.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)fontSize));
                    size = gc.textExtent(LicenseKeyInputDialog.getPlaceholderText(), 2);
                    if (size.x > maxWidth || size.y > maxHeight) {
                        --fontSize;
                        size = null;
                    }
                    if (size != null) return fontSize;
                } while (fontSize > 0);
            }
            return fontSize;
        }
        finally {
            gc.dispose();
        }
    }

    private Control createInputLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        label.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        return label;
    }

    private Control createInput(Composite parent, final String propName, boolean wrap, int height, final int fontSize) {
        int style = 2048;
        style = wrap ? (style |= 0x40) : (style |= 4);
        final Text input = new Text(parent, style);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 320;
        gridData.widthHint = 320;
        gridData.heightHint = height;
        input.setLayoutData((Object)gridData);
        String initValue = this.data.getProperty(propName);
        if (initValue != null) {
            input.setText(initValue);
        }
        if (fontSize > 0) {
            input.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)fontSize));
            input.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle area = input.getClientArea();
                    int newFontSize = LicenseKeyInputDialog.this.calcFontSize(fontSize, area.width - 10, area.height - 10);
                    if (newFontSize != fontSize) {
                        input.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)newFontSize));
                    }
                }
            });
        }
        input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LicenseKeyInputDialog.this.setErrorMessage(null);
                String value = ((Text)e.widget).getText();
                LicenseKeyInputDialog.this.data.setProperty(propName, value);
                LicenseKeyInputDialog.this.updateButtonStatus();
            }
        });
        if (wrap) {
            input.addListener(1, new Listener(){

                public void handleEvent(Event event) {
                    if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)13)) {
                        LicenseKeyInputDialog.this.buttonPressed(0);
                        event.doit = false;
                    }
                }
            });
        }
        return input;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = -1;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        Composite leftBar = new Composite(composite, 0);
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 0;
        leftLayout.makeColumnsEqualWidth = true;
        leftLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        leftLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        leftLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        leftLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        leftBar.setLayout((Layout)leftLayout);
        GridData leftLayoutData = new GridData(1, 0x1000000, true, false);
        leftLayoutData.widthHint = -1;
        leftLayoutData.heightHint = -1;
        leftBar.setLayoutData((Object)leftLayoutData);
        leftBar.setFont(parent.getFont());
        this.createButtonsFroLeftButtonBar(leftBar);
        Composite buttonBar = (Composite)super.createButtonBar(composite);
        Control[] cons = buttonBar.getChildren();
        if (cons.length == 2) {
            Button ok = (Button)cons[0];
            Button cancel = (Button)cons[1];
            if (!this.showClear) {
                ok.setText(Messages.LicenseKeyInputDialog_VerifyButton_Text);
            }
            cancel.setText(Messages.LicenseKeyInputDialog_BackButton_Text);
        }
        return buttonBar;
    }

    protected void createButtonsFroLeftButtonBar(Composite parent) {
        if (this.showClear) {
            this.createButton(parent, 1024, Messages.LicenseKeyInputDialog_Clear_buttonText, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (1024 == buttonId) {
            this.clearPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void clearPressed() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.LicenseKeyInputDialog_ClearDialog_title, (String)Messages.LicenseKeyInputDialog_ClearDialog_message)) {
            this.data.remove("TimeSmilesInMyHand");
            this.data.remove("WalkingInTheMorning");
            this.setReturnCode(1024);
            this.close();
        }
    }

    private void updateButtonStatus() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.canFinish());
        }
        if ((button = this.getButton(1024)) != null && !button.isDisposed()) {
            button.setEnabled(this.hasValue("WalkingInTheMorning") || this.hasValue("TimeSmilesInMyHand"));
        }
    }

    private boolean canFinish() {
        return this.hasValue("TimeSmilesInMyHand") && this.hasValue("WalkingInTheMorning");
    }

    private boolean hasValue(String propName) {
        String value = this.data.getProperty(propName);
        return value != null && !"".equals(value);
    }

    private static synchronized String getPlaceholderText() {
        if (__PLACEHOLDER_TEXT__ == null) {
            StringBuilder sb = new StringBuilder(315);
            int i = 0;
            while (i < 7) {
                int j = 0;
                while (j < 9) {
                    if (j > 0) {
                        sb.append('-');
                    }
                    sb.append("XXXXX");
                    ++j;
                }
                sb.append(System.getProperty("line.separator"));
                ++i;
            }
            __PLACEHOLDER_TEXT__ = sb.toString();
        }
        return __PLACEHOLDER_TEXT__;
    }

    private void setImage(Label imageLabel, Composite parent) {
        URL url;
        if (this.showClear && (url = Platform.getBundle((String)"net.xmind.verify").getEntry(ICON_VALID)) != null) {
            try {
                imageLabel.setImage(new Image(null, url.openStream()));
                return;
            }
            catch (IOException iOException) {}
        }
        imageLabel.setImage(parent.getDisplay().getSystemImage(2));
    }

    private String getLicenseTo() {
        return this.data.getProperty("TimeSmilesInMyHand");
    }
}

