/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.ICompoundDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundDecoration
extends AbstractDecoration
implements ICompoundDecoration {
    private List<IDecoration> decorations = new ArrayList<IDecoration>();

    public CompoundDecoration() {
    }

    public CompoundDecoration(String id) {
        super(id);
    }

    protected List<IDecoration> getDecorations() {
        return this.decorations;
    }

    @Override
    public IDecoration getDecoration(int index) {
        if (index < 0 || index >= this.decorations.size()) {
            return null;
        }
        return this.decorations.get(index);
    }

    @Override
    public IDecoration setDecoration(IFigure figure, int index, IDecoration decoration) {
        if (index < 0 || index >= this.decorations.size()) {
            return null;
        }
        IDecoration set = this.decorations.set(index, decoration);
        if (decoration != null) {
            this.update(figure, decoration);
        }
        return set;
    }

    protected void update(IFigure figure, IDecoration decoration) {
        decoration.setAlpha(figure, this.getAlpha());
        decoration.setVisible(figure, this.isVisible());
    }

    @Override
    public void add(IFigure figure, IDecoration decoration) {
        this.add(figure, -1, decoration);
    }

    @Override
    public void add(IFigure figure, int index, IDecoration decoration) {
        if (index < 0 || index > this.decorations.size()) {
            this.decorations.add(decoration);
        } else {
            this.decorations.add(index, decoration);
        }
        if (decoration != null) {
            this.update(figure, decoration);
        }
    }

    @Override
    public int size() {
        return this.decorations.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decorations.isEmpty();
    }

    @Override
    public boolean contains(IDecoration decoration) {
        return this.decorations.contains(decoration);
    }

    @Override
    public int indexOf(IDecoration decoration) {
        return this.decorations.indexOf(decoration);
    }

    @Override
    public IDecoration move(IFigure figure, int oldIndex, int newIndex) {
        IDecoration decoration = this.decorations.remove(oldIndex);
        this.decorations.add(newIndex, decoration);
        if (decoration != null) {
            this.update(figure, decoration);
        }
        return decoration;
    }

    @Override
    public IDecoration remove(IFigure figure, int index) {
        if (index < 0 || index >= this.decorations.size()) {
            return null;
        }
        return this.decorations.remove(index);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            decoration.invalidate();
        }
    }

    @Override
    public void validate(IFigure figure) {
        super.validate(figure);
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            decoration.validate(figure);
        }
    }

    @Override
    public void setAlpha(IFigure figure, int alpha) {
        super.setAlpha(figure, alpha);
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            decoration.setAlpha(figure, alpha);
        }
    }

    @Override
    public boolean isVisible() {
        boolean visible = false;
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            visible |= decoration.isVisible();
        }
        return visible & super.isVisible();
    }

    @Override
    public void setVisible(IFigure figure, boolean visible) {
        super.setVisible(figure, visible);
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            decoration.setVisible(figure, visible);
        }
    }

    @Override
    protected void performPaint(IFigure figure, Graphics g) {
        for (IDecoration decoration : this.decorations) {
            if (decoration == null) continue;
            decoration.paint(figure, g);
        }
    }
}

