/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.part.IPartSite;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.part.PartRegistry;
import org.xmind.gef.util.Properties;

public class PartSite
implements IPartSite {
    private IPart host = null;
    private IRootPart root = null;

    public PartSite(IPart part) {
        this.host = part;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRootPart.class) {
            return this.getRoot();
        }
        if (adapter == EditDomain.class) {
            return this.getDomain();
        }
        if (adapter == IViewer.class) {
            return this.getViewer();
        }
        if (adapter == IPartFactory.class) {
            return this.getPartFactory();
        }
        if (adapter == PartRegistry.class) {
            return this.getPartRegistry();
        }
        if (adapter == Properties.class) {
            return this.getProperties();
        }
        return this.host.getAdapter(adapter);
    }

    public IRootPart getRoot() {
        if (this.root == null) {
            this.root = this.findRootPart();
        }
        return this.root;
    }

    protected IRootPart findRootPart() {
        if (this.host instanceof IRootPart) {
            return (IRootPart)this.host;
        }
        IPart parent = this.host.getParent();
        if (parent != null) {
            return parent.getSite().getRoot();
        }
        return null;
    }

    public IPart getPart() {
        return this.host;
    }

    public EditDomain getDomain() {
        return this.getViewer().getEditDomain();
    }

    public IViewer getViewer() {
        IRootPart rootPart = this.getRoot();
        return rootPart == null ? null : rootPart.getViewer();
    }

    public IPartFactory getPartFactory() {
        IViewer viewer = this.getViewer();
        return viewer == null ? null : viewer.getPartFactory();
    }

    public PartRegistry getPartRegistry() {
        IViewer viewer = this.getViewer();
        return viewer == null ? null : viewer.getPartRegistry();
    }

    public Properties getProperties() {
        IViewer viewer = this.getViewer();
        return viewer == null ? null : viewer.getProperties();
    }

    public Shell getShell() {
        Control control = this.getViewerControl();
        return control == null || control.isDisposed() ? null : control.getShell();
    }

    public Control getViewerControl() {
        IViewer viewer = this.getViewer();
        return viewer == null ? null : viewer.getControl();
    }
}

