/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.xmind.ui.internal.ToolkitPlugin;
import org.xmind.ui.util.JobPool;

public class WebImageManager {
    private static final Map<String, String> mime = new HashMap<String, String>();
    private static final int ID_LENGTH = 26;
    private static final char PADDING_CHAR = '0';
    private static final Random random;
    private static WebImageManager webImageManager;

    static {
        mime.put("image/bmp", ".bmp");
        mime.put("image/gif", ".gif");
        mime.put("image/x-icon", ".ico");
        mime.put("image/jpeg", ".jpg");
        mime.put("image/png", ".png");
        mime.put("image/tiff", ".tiff");
        random = new Random(System.currentTimeMillis());
        webImageManager = null;
    }

    private WebImageManager() {
    }

    public void requestWebImage(final String imageUrl, JobPool jobPool, final WebImageCallback callback) {
        if (callback == null) {
            return;
        }
        if (imageUrl == null) {
            callback.handleWith(null);
            return;
        }
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(null, 100);
                String imageFilePath = WebImageManager.this.createWebImageFile(imageUrl);
                callback.handleWith(imageFilePath);
                monitor.worked(100);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        if (jobPool != null) {
            jobPool.scheduleJob(job, null);
        } else {
            job.schedule();
        }
    }

    private String createWebImageFile(String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String tempImageFilePath = null;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(imageUrl).openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return null;
            }
            String contentType = connection.getHeaderField("Content-Type");
            if (contentType == null) {
                return null;
            }
            String imageExtension = WebImageManager.getImageExtension(contentType);
            if (imageExtension == null) {
                return null;
            }
            try {
                inputStream = connection.getInputStream();
                tempImageFilePath = this.getTempImageFilePath(imageUrl, imageExtension);
                File file = new File(tempImageFilePath);
                WebImageManager.ensureFileParent(file);
                outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int num = 0;
                while ((num = inputStream.read(buffer)) != -1) {
                    ((FileOutputStream)outputStream).write(buffer, 0, num);
                    outputStream.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempImageFilePath;
    }

    private String getTempImageFilePath(String imageUrl, String imageExtension) {
        String tempFile = ToolkitPlugin.getDefault().getStateLocation().append("/webImages/" + this.createId() + imageExtension).toString();
        return tempFile;
    }

    private String createId() {
        BigInteger bi = new BigInteger(128, random);
        String id = bi.toString(32);
        int paddingLength = 26 - id.length();
        if (paddingLength > 0) {
            StringBuffer buf = new StringBuffer(26);
            int i = 0;
            while (i < paddingLength) {
                buf.append('0');
                ++i;
            }
            buf.append(id);
            return buf.toString();
        }
        return id;
    }

    private static File ensureFileParent(File f) {
        WebImageManager.ensureDirectory(f.getParentFile());
        return f;
    }

    private static File ensureDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static String getImageExtension(String contentType) {
        if (contentType == null) {
            return null;
        }
        return mime.get(contentType);
    }

    public static synchronized WebImageManager getInstance() {
        if (webImageManager == null) {
            webImageManager = new WebImageManager();
        }
        return webImageManager;
    }

    public static interface WebImageCallback {
        public void handleWith(String var1);
    }
}

