/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.views;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;

public class ContributedContentsViewTester
extends PropertyTester {
    private static final String P_IS_CONTRIBUTED = "isContributed";
    private static final String P_CONTRIBUTING_PART_ID = "contributingPartId";
    private static final String P_CONTRIBUTING_PART_CAN_ADAPT_TO = "contributingPageCanAdaptTo";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IWorkbenchPart contributingPart;
        Assert.isLegal((boolean)(receiver instanceof IWorkbenchPart), (String)("Receiver is NOT an instance of 'org.eclipse.ui.IWorkbenchPart': " + receiver));
        IWorkbenchPart part = (IWorkbenchPart)receiver;
        IContributedContentsView contributedView = ContributedContentsViewTester.getContributedContentsView(part);
        IWorkbenchPart iWorkbenchPart = contributingPart = contributedView == null ? null : contributedView.getContributingPart();
        if (P_IS_CONTRIBUTED.equals(property)) {
            return ContributedContentsViewTester.testBooleanValue(contributedView != null, expectedValue);
        }
        if (P_CONTRIBUTING_PART_ID.equals(property)) {
            return ContributedContentsViewTester.testStringValue(contributingPart == null ? null : contributingPart.getSite().getId(), expectedValue);
        }
        if (P_CONTRIBUTING_PART_CAN_ADAPT_TO.equals(property)) {
            return ContributedContentsViewTester.testAdapter(contributedView, expectedValue instanceof String ? (String)expectedValue : null);
        }
        Assert.isLegal((boolean)false, (String)("Unrecognized property: " + property));
        return false;
    }

    private static boolean testStringValue(String actualValue, Object expectedValue) {
        if ("".equals(expectedValue)) {
            expectedValue = null;
        } else if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        return actualValue == expectedValue || actualValue != null && actualValue.equals(expectedValue);
    }

    private static boolean testBooleanValue(boolean actualValue, Object expectedValue) {
        if (expectedValue == null || "".equals(expectedValue)) {
            return actualValue;
        }
        if (expectedValue instanceof String) {
            return Boolean.parseBoolean((String)expectedValue) == actualValue;
        }
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue == actualValue;
        }
        Assert.isLegal((boolean)false, (String)("Unrecognized expected value: " + expectedValue));
        return false;
    }

    private static IContributedContentsView getContributedContentsView(IWorkbenchPart part) {
        if (part instanceof IContributedContentsView) {
            return (IContributedContentsView)part;
        }
        IContributedContentsView ccv = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (ccv != null) {
            return ccv;
        }
        return (IContributedContentsView)Platform.getAdapterManager().getAdapter((Object)part, IContributedContentsView.class);
    }

    private static boolean testAdapter(Object obj, String adapterTypeName) {
        if (obj == null || adapterTypeName == null) {
            return false;
        }
        Object adapted = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (Expressions.isInstanceOf((Object)obj, (String)adapterTypeName)) {
            adapted = obj;
        } else if (manager.hasAdapter(obj, adapterTypeName)) {
            adapted = manager.getAdapter(obj, adapterTypeName);
        } else {
            if (obj instanceof IAdaptable) {
                Class<?> typeClazz = ContributedContentsViewTester.loadClass(obj.getClass().getClassLoader(), adapterTypeName);
                if (typeClazz == null) {
                    return false;
                }
                adapted = ((IAdaptable)obj).getAdapter(typeClazz);
            }
            if (adapted == null) {
                return false;
            }
        }
        return adapted != null;
    }

    private static Class<?> loadClass(ClassLoader loader, String name) {
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }
}

