/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public class GraphicalEditorPagePopupPreviewHelper {
    private static final int SHELL_MAX_WIDTH = 200;
    private static final int SHELL_MAX_HEIGHT = 200;
    private static final int CONTENTS_MAX_WIDTH = 1000;
    private static final int CONTENTS_MAX_HEIGHT = 1000;
    private static final int SPACING = 5;
    private final IGraphicalEditor editor;
    private CTabFolder tabFolder;
    private int index = -1;
    private IFigure paintingContents = null;
    private IFigure boundsContents = null;
    private Rectangle bounds = null;
    private Shell popup = null;
    private int borderWidth = 0;

    public GraphicalEditorPagePopupPreviewHelper(IGraphicalEditor editor, CTabFolder tabFolder) {
        this.editor = editor;
        this.tabFolder = tabFolder;
        this.hookTabFolder();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    protected int getAppliedBorderWidth() {
        if (Util.isMac()) {
            return this.getBorderWidth() + 1;
        }
        return this.getBorderWidth();
    }

    private void hookTabFolder() {
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 32: {
                        GraphicalEditorPagePopupPreviewHelper.this.showPopup(event);
                        break;
                    }
                    case 5: {
                        GraphicalEditorPagePopupPreviewHelper.this.checkPopup(event);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 27: 
                    case 37: {
                        GraphicalEditorPagePopupPreviewHelper.this.hidePopup();
                    }
                }
            }
        };
        this.tabFolder.addListener(32, listener);
        this.tabFolder.addListener(5, listener);
        this.tabFolder.addListener(6, listener);
        this.tabFolder.addListener(7, listener);
        this.tabFolder.addListener(3, listener);
        this.tabFolder.addListener(8, listener);
        this.tabFolder.addListener(4, listener);
        this.tabFolder.addListener(37, listener);
        this.tabFolder.addListener(12, listener);
        this.tabFolder.addListener(16, listener);
        this.tabFolder.getShell().addListener(27, listener);
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GraphicalEditorPagePopupPreviewHelper.this.tabFolder != null && !GraphicalEditorPagePopupPreviewHelper.this.tabFolder.isDisposed()) {
                    GraphicalEditorPagePopupPreviewHelper.this.tabFolder.getShell().removeListener(27, listener);
                }
            }
        });
    }

    private void showPopup(Event e) {
        IGraphicalViewer viewer;
        IGraphicalEditorPage page;
        int index;
        if (this.popup != null) {
            return;
        }
        CTabItem item = this.tabFolder.getItem(new org.eclipse.swt.graphics.Point(e.x, e.y));
        if (item != null && (index = this.tabFolder.indexOf(item)) >= 0 && (page = this.editor.getPage(index)) != null && !page.isDisposed() && (viewer = page.getViewer()) != null && !viewer.getControl().isDisposed()) {
            this.createPopup(item, viewer);
            this.index = index;
        }
    }

    private void createPopup(CTabItem item, IGraphicalViewer viewer) {
        this.paintingContents = this.getPaintingContents(viewer);
        this.boundsContents = this.getBoundsContents(this.paintingContents, viewer);
        if (this.paintingContents != null) {
            this.bounds = this.calcContentsBounds(this.boundsContents, viewer);
            this.createPopup(item);
            if (this.popup != null && !this.popup.isDisposed()) {
                this.popup.setVisible(true);
            }
        }
    }

    protected IFigure getPaintingContents(IGraphicalViewer viewer) {
        IFigure contents = viewer.getCanvas().getViewport().getContents();
        if (contents != null) {
            return contents;
        }
        return viewer.getCanvas().getLightweightSystem().getRootFigure();
    }

    protected IFigure getBoundsContents(IFigure paintingContents, IGraphicalViewer viewer) {
        IPart contentsPart = viewer.getRootPart().getContents();
        if (contentsPart instanceof IGraphicalPart && contentsPart.getStatus().isActive()) {
            return ((IGraphicalPart)contentsPart).getFigure();
        }
        return paintingContents;
    }

    protected Rectangle calcContentsBounds(IFigure contents, IGraphicalViewer viewer) {
        Rectangle bounds = this.getBaseBounds(contents);
        int width = Math.min(bounds.width, 1000);
        int height = Math.min(bounds.height, 1000);
        Point origin = this.getOrigin(contents, viewer);
        if (origin != null) {
            int x = origin.x - width / 2;
            int y = origin.y - height / 2;
            bounds.x = Math.max(bounds.x, Math.min(bounds.x + bounds.width - width, x));
            bounds.y = Math.max(bounds.y, Math.min(bounds.y + bounds.height - height, y));
        } else {
            bounds.x = -width / 2;
            bounds.y = -height / 2;
        }
        bounds.width = width;
        bounds.height = height;
        return bounds;
    }

    protected Rectangle getBaseBounds(IFigure contents) {
        if (contents instanceof FreeformFigure) {
            return ((FreeformFigure)contents).getFreeformExtent().getCopy();
        }
        return contents.getBounds().getCopy();
    }

    protected Point getOrigin(IFigure contents, IGraphicalViewer viewer) {
        if (contents instanceof IOriginBased) {
            return ((IOriginBased)contents).getOrigin();
        }
        return null;
    }

    private void createPopup(CTabItem item) {
        this.popup = new Shell(this.editor.getSite().getShell(), this.getPopupShellStyle());
        this.hookPopup(this.popup);
        this.configurePopup(this.popup, item);
    }

    protected int getPopupShellStyle() {
        int style = 802816;
        style = Util.isMac() ? (style |= 8) : (style |= 0x10);
        return style;
    }

    private void hookPopup(Shell popup) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        GraphicalEditorPagePopupPreviewHelper.this.paintPopup(event);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 15: 
                    case 26: 
                    case 32: 
                    case 37: {
                        GraphicalEditorPagePopupPreviewHelper.this.hidePopup();
                    }
                }
            }
        };
        popup.addListener(9, listener);
        popup.addListener(6, listener);
        popup.addListener(7, listener);
        popup.addListener(5, listener);
        popup.addListener(3, listener);
        popup.addListener(4, listener);
        popup.addListener(37, listener);
        popup.addListener(32, listener);
        popup.addListener(26, listener);
        popup.addListener(15, listener);
        popup.addListener(1, listener);
        popup.addListener(2, listener);
    }

    protected void configurePopup(Shell popup, CTabItem item) {
        int y;
        int doubleBorderWidth = this.getAppliedBorderWidth() * 2;
        int maxWidth = 200 - doubleBorderWidth;
        int maxHeight = 200 - doubleBorderWidth;
        Dimension size = Geometry.getScaledConstrainedSize((int)this.bounds.width, (int)this.bounds.height, (int)maxWidth, (int)maxHeight);
        size.expand(doubleBorderWidth, doubleBorderWidth);
        org.eclipse.swt.graphics.Rectangle trim = popup.computeTrim(0, 0, size.width, size.height);
        int width = trim.width;
        int height = trim.height;
        popup.setSize(width, height);
        org.eclipse.swt.graphics.Rectangle itemBounds = item.getBounds();
        org.eclipse.swt.graphics.Point leftTop = this.tabFolder.toDisplay(itemBounds.x, itemBounds.y);
        org.eclipse.swt.graphics.Rectangle displayArea = Display.getCurrent().getClientArea();
        int x = leftTop.x + itemBounds.width / 2 - width / 2;
        if (x + width > displayArea.x + displayArea.width) {
            x = displayArea.x + displayArea.width - width;
        }
        if (x < displayArea.x) {
            x = displayArea.x;
        }
        if (this.tabFolder.getTabPosition() == 1024) {
            y = leftTop.y - 5 - height;
            if (y < displayArea.y) {
                y = displayArea.y;
            }
        } else {
            y = leftTop.y + itemBounds.height + 5;
            if (y + height > displayArea.y + displayArea.height) {
                y = displayArea.y + displayArea.height - height;
            }
        }
        popup.setLocation(x, y);
    }

    protected void paintPopup(Event e) {
        org.eclipse.swt.graphics.Rectangle clientArea = this.popup.getClientArea();
        int border = this.getAppliedBorderWidth();
        int x = clientArea.x + border;
        int y = clientArea.y + border;
        double w = clientArea.width - border - border;
        double h = clientArea.height - border - border;
        GC gc = e.gc;
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.pushState();
        double horizontalScale = w / (double)this.bounds.width;
        double verticalScale = h / (double)this.bounds.height;
        double scale = Math.max(horizontalScale, verticalScale);
        swtGraphics.translate(x, y);
        SWTGraphics g = swtGraphics;
        ScaledGraphics sg = null;
        if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
            sg = new ScaledGraphics((Graphics)swtGraphics);
            sg.scale(scale);
            g = sg;
        } else {
            g.scale(scale);
        }
        g.translate(-this.bounds.x, -this.bounds.y);
        try {
            this.paintFigure(this.paintingContents, (Graphics)g);
        }
        finally {
            if (sg != null) {
                sg.dispose();
            }
            swtGraphics.popState();
            swtGraphics.dispose();
        }
        if (border > 0) {
            gc.setForeground(e.display.getSystemColor(15));
            gc.setAlpha(255);
            gc.setLineWidth(border);
            gc.setLineStyle(1);
            gc.setClipping(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            gc.drawRectangle(clientArea.x + border / 2, clientArea.y + border / 2, clientArea.width - border, clientArea.height - border);
        }
    }

    protected void paintFigure(IFigure figure, Graphics graphics) {
        figure.paint(graphics);
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        this.paintingContents = null;
        this.boundsContents = null;
        this.bounds = null;
        this.index = -1;
    }

    private void checkPopup(Event e) {
        CTabItem item = this.tabFolder.getItem(new org.eclipse.swt.graphics.Point(e.x, e.y));
        if (item == null) {
            this.hidePopup();
            return;
        }
        int index = this.tabFolder.indexOf(item);
        if (index < 0) {
            this.hidePopup();
            return;
        }
        if (index != this.index) {
            boolean showing = this.popup != null;
            this.hidePopup();
            if (showing) {
                this.showPopup(e);
            }
            return;
        }
        IGraphicalEditorPage page = this.editor.getPage(index);
        if (page == null || page.isDisposed()) {
            this.hidePopup();
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null || viewer.getControl().isDisposed()) {
            this.hidePopup();
            return;
        }
    }
}

