/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.animation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.IPlaybackProvider;

public class LayoutPlaybackProvider
implements IPlaybackProvider {
    public boolean doPlayback(IFigure figure, IGraphicalPart part, Object initState, Object finalState, float progress) {
        Map initial = (Map)initState;
        Map ending = (Map)finalState;
        List children = this.getAnimatableChildren(figure, part);
        int i = 0;
        while (i < children.size()) {
            Object childState;
            Object child = children.get(i);
            Object childInit = initial.get(child);
            Object childEnd = ending.get(child);
            if (childInit != null && childEnd != null && (childState = this.calcCurrentState(child, childInit, childEnd, progress, figure, part)) != null) {
                this.doPlayback(child, childState, progress, figure, part);
            }
            ++i;
        }
        return true;
    }

    protected void doPlayback(Object child, Object childState, float progress, IFigure figure, IGraphicalPart part) {
        if (child instanceof IFigure && childState instanceof Rectangle) {
            ((IFigure)child).setBounds((Rectangle)childState);
        }
    }

    protected Object calcCurrentState(Object child, Object childInit, Object childEnd, float progress, IFigure figure, IGraphicalPart part) {
        if (childInit instanceof Rectangle && childEnd instanceof Rectangle) {
            float ssergorp = 1.0f - progress;
            Rectangle rect1 = (Rectangle)childInit;
            Rectangle rect2 = (Rectangle)childEnd;
            int x = Math.round(progress * (float)rect2.x + ssergorp * (float)rect1.x);
            int y = Math.round(progress * (float)rect2.y + ssergorp * (float)rect1.y);
            int width = Math.round(progress * (float)rect2.width + ssergorp * (float)rect1.width);
            int height = Math.round(progress * (float)rect2.height + ssergorp * (float)rect1.height);
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    protected List getAnimatableChildren(IFigure figure, IGraphicalPart part) {
        return figure.getChildren();
    }

    public Object getState(IFigure figure, IGraphicalPart part) {
        HashMap childrenStates = new HashMap();
        List children = this.getAnimatableChildren(figure, part);
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            Object state = this.getChildState(child, figure, part);
            childrenStates.put(child, state);
            ++i;
        }
        return childrenStates;
    }

    protected Object getChildState(Object child, IFigure figure, IGraphicalPart part) {
        if (child instanceof IFigure) {
            IFigure childFigure = (IFigure)child;
            return childFigure.getBounds().getCopy();
        }
        return null;
    }
}

