/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.ContentPane;
import org.xmind.ui.gallery.GalleryLayout;

public class ContentPaneDecorator
extends Decorator {
    public static final ContentPaneDecorator DEFAULT = new ContentPaneDecorator();
    private static final GalleryLayout DEFAULT_LAYOUT = new GalleryLayout();

    public void decorate(IGraphicalPart part, IFigure figure) {
        Viewport viewport;
        super.decorate(part, figure);
        ContentPane contentPane = (ContentPane)part.getFigure();
        IViewer viewer = part.getSite().getViewer();
        Properties properties = viewer.getProperties();
        boolean horizontal = properties.getBoolean("org.xmind.ui.gallery.horizontal", false);
        boolean wrap = properties.getBoolean("org.xmind.ui.gallery.wrap", false);
        GalleryLayout layout = (GalleryLayout)properties.get("org.xmind.ui.gallery.layout");
        if (layout == null) {
            layout = DEFAULT_LAYOUT;
        }
        contentPane.setMajorAlignment(layout.majorAlignment);
        contentPane.setMinorAlignment(layout.minorAlignment);
        contentPane.setMajorSpacing(layout.majorSpacing);
        contentPane.setMinorSpacing(layout.minorSpacing);
        contentPane.setHorizontal(horizontal);
        contentPane.setWrap(wrap);
        contentPane.setBorder((Border)new MarginBorder(layout.getMargins()));
        SpaceCollaborativeEngine sce = (SpaceCollaborativeEngine)properties.get("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine");
        if (sce != null) {
            sce.register(viewer, contentPane);
            contentPane.setSpaceCollaborativeEngine(sce);
        }
        if ((viewport = this.findViewport((IFigure)contentPane)) != null) {
            boolean fill;
            boolean bl = fill = layout.minorAlignment == 3;
            if (horizontal) {
                viewport.setContentsTracksWidth(wrap);
                viewport.setContentsTracksHeight(fill);
            } else {
                viewport.setContentsTracksHeight(wrap);
                viewport.setContentsTracksWidth(fill);
            }
        }
    }

    protected Viewport findViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        if (figure instanceof Viewport) {
            return (Viewport)figure;
        }
        return this.findViewport(figure.getParent());
    }
}

