/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.core.licensing.ILicenseAgent;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.ui.internal.statushandlers.IErrorReporter;

public class ServiceManager {
    private boolean active = false;
    private IErrorReporter errorReporter = null;
    private IUsageDataSampler usageDataSampler = null;
    private ILicenseAgent licenseAgent = null;
    private CathyPlugin plugin = CathyPlugin.getDefault();

    public void activate() {
        if (this.active) {
            return;
        }
        this.plugin.setUsageDataCollector(this.usageDataSampler);
        this.plugin.setErrorReporter(this.errorReporter);
        this.plugin.setLicenseAgent(this.licenseAgent);
        this.active = true;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.plugin.setUsageDataCollector(null);
        this.plugin.setErrorReporter(null);
        this.plugin.setLicenseAgent(null);
        this.active = false;
    }

    public void setErrorReporter(IErrorReporter reporter) {
        this.errorReporter = reporter;
        if (this.active) {
            this.plugin.setErrorReporter(reporter);
        }
    }

    public void unsetErrorReporter(IErrorReporter reporter) {
        if (reporter != this.errorReporter) {
            return;
        }
        this.errorReporter = null;
        if (this.active) {
            this.plugin.setErrorReporter(null);
        }
    }

    public void setUsageDataSampler(IUsageDataSampler sampler) {
        this.usageDataSampler = sampler;
        if (this.active) {
            this.plugin.setUsageDataCollector(sampler);
        }
    }

    public void unsetUsageDataSampler(IUsageDataSampler sampler) {
        if (sampler == this.usageDataSampler) {
            return;
        }
        this.usageDataSampler = null;
        if (this.active) {
            this.plugin.setUsageDataCollector(null);
        }
    }

    public void setLicenseAgent(ILicenseAgent agent) {
        this.licenseAgent = agent;
        if (this.active) {
            this.plugin.setLicenseAgent(agent);
        }
    }

    public void unsetLicenseAgent(ILicenseAgent agent) {
        if (agent == this.licenseAgent) {
            return;
        }
        this.licenseAgent = null;
        if (this.active) {
            this.plugin.setLicenseAgent(null);
        }
    }
}

