/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ICloneData;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.CreateCommand;

public class CreateSheetCommand
extends CreateCommand {
    private IWorkbook parent;
    private int index;
    private ISheet sheet;
    private ITopic topic;
    private ICloneData cloneData;

    public CreateSheetCommand(IWorkbook parent, ITopic topic) {
        this(parent, -1);
        this.topic = topic;
    }

    public CreateSheetCommand(IWorkbook parent, int index) {
        Assert.isNotNull((Object)parent);
        Assert.isTrue((index <= parent.getSheets().size() ? 1 : 0) != 0);
        this.parent = parent;
        this.index = index;
    }

    protected boolean canCreate() {
        if (this.sheet == null) {
            this.sheet = this.parent.createSheet();
            if (this.topic != null) {
                ICloneData clone;
                this.cloneData = clone = this.parent.clone(Arrays.asList(this.topic));
                ITopic cloneTopic = (ITopic)clone.get((Object)this.topic);
                this.sheet.replaceRootTopic(cloneTopic);
            }
        }
        return this.sheet != null;
    }

    protected Object create() {
        this.canCreate();
        return this.sheet;
    }

    public void redo() {
        this.parent.addSheet((ISheet)this.getSource(), this.index);
        super.redo();
    }

    public void undo() {
        this.parent.removeSheet((ISheet)this.getSource());
        super.undo();
    }

    public ICloneData getCloneData() {
        return this.cloneData;
    }
}

