/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.IFreeableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.branch.RadialData;
import org.xmind.ui.internal.branch.RadialStructure;
import org.xmind.ui.internal.branch.RadialUtils;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

public abstract class BaseRadialStructure
extends AbstractBranchStructure
implements ILockableBranchStructureExtension,
IFreeableBranchStructureExtension {
    public static final String CACHE_NUMBER_RIGHT_BRANCHES = String.valueOf(RadialStructure.class.getName()) + ".numberRightBranches";
    public Set<IBranchPart> calculatingBranches = new HashSet<IBranchPart>();

    @Override
    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof RadialData;
    }

    @Override
    protected Object createStructureData(IBranchPart branch) {
        return new RadialData(branch);
    }

    protected RadialData getRadialData(IBranchPart branch) {
        return (RadialData)this.getStructureData(branch);
    }

    public boolean isChildLeft(IBranchPart branch, IBranchPart child) {
        Point pos;
        if (branch == null) {
            return true;
        }
        if (branch.isCentral() && (pos = (Point)MindMapUtils.getCache((IPart)child, "org.xmind.ui.cache.preferredPosition")) != null) {
            return RadialUtils.isLeft(0, pos.x);
        }
        if (this.calculatingBranches.contains(branch)) {
            return false;
        }
        this.calculatingBranches.add(branch);
        int index = branch.getSubBranches().indexOf(child);
        boolean left = index >= 0 ? index >= this.getRadialData(branch).getNumRight() : (branch.getSummaryBranches().contains(child) ? this.isSummaryChildLeft(branch, child) : (branch.getCalloutBranches().contains(child) ? this.isChildLeft(branch.getParentBranch(), branch) : RadialUtils.isLeft(this.getReference((IBranchPart)branch).x, this.getReference((IBranchPart)child).x)));
        this.calculatingBranches.remove(branch);
        return left;
    }

    public boolean isSummaryChildLeft(IBranchPart branch, IBranchPart child) {
        ISummaryPart summary = MindMapUtils.findAttachedSummary(branch, child);
        if (summary != null) {
            int direction = this.getSummaryDirection(branch, summary);
            return direction == 8;
        }
        return false;
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        IBranchPart subBranch;
        int index;
        List<IBranchPart> enclosingBranches = summary.getEnclosingBranches();
        if (!enclosingBranches.isEmpty() && (index = (subBranch = enclosingBranches.get(0)).getBranchIndex()) >= 0 && index >= this.getRadialData(branch).getNumRight()) {
            return 8;
        }
        return 16;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public Point getReference(IBranchPart branch) {
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            return ((IReferencedFigure)topic.getFigure()).getReference();
        }
        return ((IReferencedFigure)branch.getFigure()).getReference();
    }

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        IFigure fig = plusMinus.getFigure();
        Rectangle topicBounds = info.getCheckedClientArea();
        Dimension pmSize = fig.getPreferredSize();
        int pmx = ref.x - pmSize.width / 2;
        int pmy = topicBounds.bottom();
        Rectangle pmBounds = new Rectangle(pmx, pmy, pmSize.width, pmSize.height);
        info.put(fig, pmBounds);
    }

    protected Dimension getOffset(IBranchPart subBranch) {
        Point pos = (Point)MindMapUtils.getCache((IPart)subBranch, "org.xmind.ui.cache.preferredPosition");
        if (pos != null) {
            return new Dimension(pos.x, pos.y);
        }
        return null;
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        int numSecond;
        if ("navigate_right".equals(navReqType)) {
            if (!branch.getSubBranches().isEmpty()) {
                return this.getSubTopicPart(branch, 0);
            }
        } else if ("navigate_left".equals(navReqType) && (numSecond = this.getRadialData(branch).getNumLeft()) > 0) {
            int numFirst = this.getRadialData(branch).getNumRight();
            return this.getSubTopicPart(branch, numFirst);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.isChildLeft(branch, subBranch) ? 16 : 8;
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    @Override
    public boolean isChildrenFreeable(IBranchPart branch) {
        return branch.isCentral();
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        Point parentRef = this.getReference(branch);
        Point childRef = key.getFigure().getReference();
        Rectangle childBounds = key.getFigure().getBounds();
        Point childAnc = RadialUtils.isLeft(parentRef.x, childRef.x) ? childBounds.getRight() : childBounds.getLeft();
        int d = (int)childAnc.getDistance(parentRef);
        Dimension ovalSize = this.getRadialData(branch).getOvalSize();
        int r = Math.max(ovalSize.width, ovalSize.height);
        if (d <= r + 50) {
            return d;
        }
        if (d <= r + 300) {
            return d * d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        ITopicPart topic = branch.getTopicPart();
        Point ref = topic != null ? ((IReferencedFigure)topic.getFigure()).getReference() : ((IReferencedFigure)branch.getFigure()).getReference();
        return new RadiationInsertion(branch, this.calcInsIndex(branch, key, true), this.calcInsSize(branch, key), this.calcInsSide(branch, ref, key));
    }

    @Override
    public void lock(IBranchPart branch) {
        MindMapUtils.setCache((IPart)branch, CACHE_NUMBER_RIGHT_BRANCHES, this.getRadialData(branch).getNumRight());
    }

    @Override
    public void unlock(IBranchPart branch) {
        MindMapUtils.flushCache((IPart)branch, CACHE_NUMBER_RIGHT_BRANCHES);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return withDisabled ? 0 : -1;
        }
        if (branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        Point childRef = key.getFigure().getReference();
        Point ref = ((IReferencedFigure)topic.getFigure()).getReference();
        RadialData cache = this.getRadialData(branch);
        int numRight = cache.getNumRight();
        int[] childrenSpacings = cache.getChildrenSpacings();
        int num = subBranches.size();
        boolean right = true;
        Dimension insSize = this.calcInsSize(branch, key);
        int insHeight = insSize.height;
        boolean insRight = this.calcInsSide(branch, ref, key);
        int startY = ref.y;
        int y = startY - cache.getRightSumSpacing() / 2;
        if (insRight) {
            y -= insHeight / 2;
        }
        int ret = 0;
        int i = 0;
        while (i < num) {
            if (i == numRight) {
                y = startY - cache.getLeftSumSpacing() / 2;
                if (!insRight) {
                    y -= insHeight / 2;
                }
                right = false;
            }
            IBranchPart subbranch = subBranches.get(i);
            IFigure subFigure = subbranch.getFigure();
            Insets refIns = RadialUtils.getRefInsets(subFigure, right);
            int hint = y - refIns.top + (refIns.getHeight() + insHeight) / 2;
            if (i < numRight) {
                if (insRight && childRef.y < hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
                if (i == numRight - 1 && childRef.x > ref.x && childRef.y >= hint) {
                    return ret;
                }
            } else {
                if (!insRight && childRef.y < hint) {
                    return ret;
                }
                if (withDisabled || subFigure.isEnabled()) {
                    ++ret;
                }
            }
            y += childrenSpacings[i];
            ++i;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IBranchPart branch, ParentSearchKey key) {
        return key.getFigure().getSize();
    }

    private boolean calcInsSide(IBranchPart branch, Point branchRef, ParentSearchKey key) {
        Point childRef = key.getFigure().getReference();
        return childRef.x > branchRef.x;
    }

    @Override
    protected RadiationInsertion getCurrentInsertion(IBranchPart branch) {
        IInsertion insertion = super.getCurrentInsertion(branch);
        return insertion instanceof RadiationInsertion ? (RadiationInsertion)insertion : null;
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 4) {
            return 1;
        }
        if (direction == 1) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    @Override
    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        Point firstLoc = this.calcFirstChildPosition(branch, key);
        if (subBranches.isEmpty()) {
            return firstLoc;
        }
        int index = this.calcInsIndex(branch, key, true);
        RadialData cache = this.getRadialData(branch);
        int subSize = subBranches.size();
        int right = cache.getNumRight();
        int left = subSize - right;
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        IBranchPart first = subBranches.get(0);
        Rectangle fBounds = first.getFigure().getBounds();
        if (index == 0) {
            int x = fBounds.x + inventSize.width / 2;
            int y = fBounds.y - (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == subSize) {
            if (subSize == 1 && this.isWithinThreshold(first)) {
                if (fBounds.bottom() > 0) {
                    int x = fBounds.x + inventSize.width / 2;
                    int y = fBounds.bottom() + (insSize.height + inventSize.height) / 2;
                    return new Point(x, y);
                }
                return new Point(firstLoc.x, -firstLoc.y);
            }
            if (left == 0) {
                return firstLoc.getNegated();
            }
            IBranchPart sub = subBranches.get(subBranches.size() - 1);
            Rectangle bounds = sub.getFigure().getBounds();
            if (left == 1 && bounds.y > 0) {
                return new Point(-firstLoc.x, firstLoc.y);
            }
            int x = bounds.right() - inventSize.width / 2;
            int y = bounds.y - (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        if (index == right) {
            boolean isRight = left == 1 && right == 1 || this.isRight(subBranches, child, right);
            IBranchPart sub = isRight ? subBranches.get(index - 1) : subBranches.get(index);
            Rectangle bounds = sub.getFigure().getBounds();
            int x = isRight ? bounds.x + inventSize.width / 2 : bounds.right() - inventSize.width / 2;
            int y = bounds.bottom() + (insSize.height + inventSize.height) / 2;
            return new Point(x, y);
        }
        boolean isRight = index < right;
        return this.calcInventPosition(subBranches.get(isRight ? index - 1 : index), subBranches.get(isRight ? index : index - 1), key, isRight);
    }

    @Override
    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        int right = this.getRadialData(branch).getNumRight();
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            if (index == right - 1 && key.getCursorPos().x < 0 && !subBranches.get(right).getFigure().isEnabled()) {
                ++index;
            }
            int delta = this.getTopicSize((IBranchPart)subBranches.get((int)index)).width / 2 - inventSize.width / 2;
            int deltaX = index < right ? -delta : delta;
            return this.getReference(subBranches.get(index)).getTranslated(deltaX, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int y = -(this.getMinorSpacing(branch) * 3 / 4 + 8) * 4;
        int x = this.getRadialData(branch).getX(y, true);
        return this.getReference(branch).getTranslated(x, y).getTranslated(key.getInvent().getSize().width / 2, 0);
    }

    protected boolean isWithinThreshold(IBranchPart subBranch) {
        return this.getBranchWeight(subBranch) < (int)(200.0 * (Math.log(2.0) + 1.0));
    }

    protected int getBranchWeight(IBranchPart branch) {
        if (branch == null) {
            return 0;
        }
        IFigure figure = branch.getFigure();
        if (figure == null) {
            return 0;
        }
        return figure.getPreferredSize().height + 30;
    }

    @Override
    protected Point calcInventPosition(IBranchPart orientation, IBranchPart assist, ParentSearchKey key, boolean isRightOrUp) {
        Dimension inventSize = key.getInvent().getSize();
        Rectangle oriBounds = orientation.getFigure().getBounds();
        Rectangle assBounds = assist.getFigure().getBounds();
        int x = isRightOrUp ? (oriBounds.x + assBounds.x) / 2 + inventSize.width / 2 : (oriBounds.right() + assBounds.right()) / 2 - inventSize.width / 2;
        int y = (oriBounds.bottom() + assBounds.y) / 2;
        Point loc = new Point(x, y);
        IBranchPart parent = orientation.getParentBranch();
        IFigure figure = parent.getTopicPart().getFigure();
        Rectangle bounds = figure.getBounds();
        if (isRightOrUp) {
            if (bounds.contains(x - inventSize.width / 2, y - inventSize.height / 2) || bounds.contains(x - inventSize.width / 2, y + inventSize.height / 2)) {
                return loc.getTranslated(bounds.right() - (loc.x - inventSize.width / 2) + this.getMajorSpacing(parent), 0);
            }
        } else if (bounds.contains(x + inventSize.width / 2, y - inventSize.height / 2) || bounds.contains(x + inventSize.width / 2, y + inventSize.height / 2)) {
            return loc.getTranslated(loc.x - inventSize.width / 2 - bounds.x - this.getMajorSpacing(parent), 0);
        }
        return loc;
    }

    protected boolean isRight(List<IBranchPart> subBranches, IBranchPart child, int right) {
        int rightWeight = 0;
        int leftWeight = 0;
        int i = 0;
        while (i < right) {
            rightWeight += this.getBranchWeight(subBranches.get(i));
            ++i;
        }
        i = right;
        while (i < subBranches.size()) {
            leftWeight += this.getBranchWeight(subBranches.get(i));
            ++i;
        }
        int insWeight = this.getBranchWeight(child);
        int newRightWeight = rightWeight + insWeight;
        int halfWeight = (rightWeight + leftWeight) / 2;
        return newRightWeight <= (newRightWeight + leftWeight) / 2 || rightWeight <= leftWeight && newRightWeight - halfWeight > halfWeight - rightWeight;
    }

    protected static class RadiationInsertion
    extends Insertion {
        boolean right;

        public RadiationInsertion(IBranchPart parent, int index, Dimension size, boolean right) {
            super(parent, index, size);
            this.right = right;
        }

        @Override
        public void pushIn() {
            super.pushIn();
        }

        @Override
        public void pullOut() {
            super.pullOut();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof RadiationInsertion)) {
                return false;
            }
            RadiationInsertion that = (RadiationInsertion)obj;
            return super.equals(obj) && this.right == that.right;
        }
    }
}

