/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;

public class AlignmentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.alignment(MindMapHandlerUtil.findContributingEditor(event), event.getParameter("org.xmind.ui.alignmentParameter"));
        return null;
    }

    private void alignment(IEditorPart editor, String param) {
        if (param == null || editor == null) {
            return;
        }
        int value = this.getAlignment(param);
        if (value == 0) {
            return;
        }
        IViewer viewer = MindMapUIPlugin.getAdapter(editor, IViewer.class);
        if (viewer == null) {
            return;
        }
        EditDomain domain = viewer.getEditDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(new Request("align").setViewer(viewer).setParameter("alignment", (Object)value));
    }

    private int getAlignment(String alignment) {
        if ("left".equals(alignment)) {
            return 1;
        }
        if ("right".equals(alignment)) {
            return 4;
        }
        if ("center".equals(alignment)) {
            return 2;
        }
        if ("top".equals(alignment)) {
            return 8;
        }
        if ("middle".equals(alignment)) {
            return 16;
        }
        if ("bottom".equals(alignment)) {
            return 32;
        }
        return 0;
    }
}

