/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;

public class RemoveMarkerFromAllTopicsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.removeMarkerFromSheet(HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event), MindMapHandlerUtil.findContributingEditor(event));
        return null;
    }

    private void removeMarkerFromSheet(ISelection selection, IEditorPart editor) {
        ICommandStack commandStack;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj == null || !(obj instanceof IMarkerRef)) {
            return;
        }
        IMarkerRef markerRef = (IMarkerRef)obj;
        String markerId = markerRef.getMarkerId();
        if (markerId == null) {
            return;
        }
        ISheet sheet = markerRef.getOwnedSheet();
        if (sheet == null) {
            return;
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        this.collectRemoveMarkerCommands(markerId, sheet.getRootTopic(), commands);
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(CommandMessages.Command_RemoveMarkerFromAllTopics, commands);
        ICommandStack iCommandStack = commandStack = editor == null ? null : (ICommandStack)editor.getAdapter(ICommandStack.class);
        if (commandStack != null) {
            commandStack.execute((Command)command);
        } else {
            command.execute();
        }
    }

    private void collectRemoveMarkerCommands(String markerId, ITopic topic, List<Command> commands) {
        for (IMarkerRef mr : topic.getMarkerRefs()) {
            if (!markerId.equals(mr.getMarkerId())) continue;
            commands.add((Command)new DeleteMarkerCommand(mr));
        }
        Iterator childrenIt = topic.getAllChildrenIterator();
        while (childrenIt.hasNext()) {
            ITopic child = (ITopic)childrenIt.next();
            this.collectRemoveMarkerCommands(markerId, child, commands);
        }
    }
}

