/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class MultipageImagePreviewViewer {
    private static final int PREF_WIDTH = 300;
    private static final int PREF_HEIGHT = 180;
    private static final int BORDER_WIDTH = 1;
    private static final int TEXT_MARGIN = 3;
    private static final double Show_Font_Multiple = 4.0;
    private static final String ENABLED = "enabled";
    private int prefWidth = 300;
    private int prefHeight = 180;
    private double x = 0.0;
    private double y = 0.0;
    private double ratio = 1.0;
    private Composite composite;
    private Composite backgroundImageComposite;
    private Image backgroundImage;
    private FigureCanvas canvas;
    private String title = null;
    private int titlePlacement = 0;
    private Label pageNumberLabel;
    private Label totalPagesLabel;
    private Label firstButton;
    private Label previousButton;
    private Label nextButton;
    private Label lastButton;
    private Image image;
    private Image wholeImage;
    public Image[] singleImages;
    private int imageIndex;
    private Layer feedbackLayer;
    private IFigure borderFigure;
    private ITextFigure headerFigure;
    private ITextFigure footerFigure;
    private IFigure textLayer;
    private IFigure pageNumberLayer;
    private ITextFigure pageNumberFigure;
    private org.eclipse.swt.graphics.Rectangle imageBorderBounds;
    private Font headerFont;
    private Font footerFont;
    private ResourceManager resources;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            MultipageImagePreviewViewer.this.handleWidgetEvent(event);
        }
    };

    public MultipageImagePreviewViewer(boolean fill) {
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(this.composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 10;
        composite2.setLayout((Layout)layout2);
        composite2.setLayoutData((Object)new org.eclipse.swt.layout.GridData(2, 2, false, false));
        this.createCanvas(composite2);
        this.createBarControls(composite2);
    }

    private void createCanvas(Composite parent) {
        this.backgroundImageComposite = new Composite(parent, 0);
        this.backgroundImageComposite.setBackground(parent.getBackground());
        this.backgroundImageComposite.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 2;
        layout.marginTop = 1;
        layout.marginRight = 6;
        layout.marginBottom = 7;
        this.backgroundImageComposite.setLayout((Layout)layout);
        LightweightSystem lws = new LightweightSystem();
        this.canvas = new FigureCanvas(this.backgroundImageComposite, 0x20000000, lws);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        org.eclipse.swt.layout.GridData layoutData = new org.eclipse.swt.layout.GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.widthHint = this.getPrefWidth() + 1 + 1;
        layoutData.heightHint = this.getPrefHeight() + 1 + 1;
        this.canvas.setLayoutData((Object)layoutData);
        this.hookCanvas((Canvas)this.canvas, new Listener(){

            public void handleEvent(Event event) {
                MultipageImagePreviewViewer.this.handleCanvasEvent(event);
            }
        });
        this.updateCanvas();
        this.createFeedbackFigure(this.canvas);
    }

    private void createFeedbackFigure(FigureCanvas canvas) {
        canvas.setViewport(new Viewport(true));
        this.feedbackLayer = new Layer();
        canvas.getViewport().setContents((IFigure)this.feedbackLayer);
        this.borderFigure = new Layer();
        this.borderFigure.setBorder((Border)new LineBorder(new LocalResourceManager(JFaceResources.getResources(), (Control)canvas).createColor(ColorUtils.toRGB((String)"#959595")), 1));
        this.feedbackLayer.add(this.borderFigure);
        this.textLayer = new Layer();
        this.textLayer.setLayoutManager((LayoutManager)new PreviewTextLayout());
        this.feedbackLayer.add(this.textLayer);
        this.headerFigure = new RotatableWrapLabel(0);
        this.headerFigure.setForegroundColor(canvas.getDisplay().getSystemColor(2));
        this.textLayer.add((IFigure)this.headerFigure);
        this.footerFigure = new RotatableWrapLabel(0);
        this.footerFigure.setForegroundColor(canvas.getDisplay().getSystemColor(2));
        this.textLayer.add((IFigure)this.footerFigure);
        this.pageNumberLayer = new Layer();
        this.textLayer.add(this.pageNumberLayer);
        org.eclipse.draw2d.GridLayout gridLayout = new org.eclipse.draw2d.GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.pageNumberLayer.setLayoutManager((LayoutManager)gridLayout);
        this.pageNumberFigure = new RotatableWrapLabel(0);
        this.pageNumberFigure.setForegroundColor(canvas.getDisplay().getSystemColor(2));
        GridData gridData = new GridData(4, 4, true, true);
        this.pageNumberLayer.add((IFigure)this.pageNumberFigure, (Object)gridData);
    }

    private void createBarControls(Composite parent) {
        Composite bar = new Composite(parent, 0);
        org.eclipse.swt.layout.GridData layoutData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        bar.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 30;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        bar.setLayout((Layout)layout);
        this.firstButton = new Label(bar, 0);
        this.firstButton.setImage(this.getIcon("nav_first.png", true));
        org.eclipse.swt.layout.GridData firstButtonData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        firstButtonData.widthHint = this.firstButton.getImage().getBounds().width;
        firstButtonData.heightHint = this.firstButton.getImage().getBounds().height;
        this.firstButton.setLayoutData((Object)firstButtonData);
        this.previousButton = new Label(bar, 0);
        this.previousButton.setImage(this.getIcon("nav_previous.png", true));
        org.eclipse.swt.layout.GridData previousButtonData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        previousButtonData.widthHint = this.previousButton.getImage().getBounds().width;
        previousButtonData.heightHint = this.previousButton.getImage().getBounds().height;
        this.previousButton.setLayoutData((Object)previousButtonData);
        Composite labelComposite = new Composite(bar, 0);
        labelComposite.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        GridLayout layout2 = new GridLayout(3, false);
        layout2.marginWidth = 20;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 10;
        layout2.verticalSpacing = 0;
        labelComposite.setLayout((Layout)layout2);
        this.pageNumberLabel = new Label(labelComposite, 0);
        this.pageNumberLabel.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        this.pageNumberLabel.setText("0");
        Label label1 = new Label(labelComposite, 0);
        label1.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        label1.setText("of");
        this.totalPagesLabel = new Label(labelComposite, 0);
        this.totalPagesLabel.setLayoutData((Object)new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false));
        this.totalPagesLabel.setText("0");
        this.nextButton = new Label(bar, 0);
        this.nextButton.setImage(this.getIcon("nav_next.png", true));
        org.eclipse.swt.layout.GridData nextButtonData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        nextButtonData.widthHint = this.nextButton.getImage().getBounds().width;
        nextButtonData.heightHint = this.nextButton.getImage().getBounds().height;
        this.nextButton.setLayoutData((Object)nextButtonData);
        this.lastButton = new Label(bar, 0);
        this.lastButton.setImage(this.getIcon("nav_last.png", true));
        org.eclipse.swt.layout.GridData lastButtonData = new org.eclipse.swt.layout.GridData(0x1000000, 0x1000000, false, false);
        lastButtonData.widthHint = this.lastButton.getImage().getBounds().width;
        lastButtonData.heightHint = this.lastButton.getImage().getBounds().height;
        this.lastButton.setLayoutData((Object)lastButtonData);
        this.hookWidget((Widget)this.firstButton, 3);
        this.hookWidget((Widget)this.previousButton, 3);
        this.hookWidget((Widget)this.nextButton, 3);
        this.hookWidget((Widget)this.lastButton, 3);
        this.updateImageButtons();
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private void handleWidgetEvent(Event event) {
        if (!Boolean.TRUE.equals(event.widget.getData(ENABLED))) {
            return;
        }
        if (event.widget == this.firstButton) {
            this.setImageIndex(0);
        } else if (event.widget == this.previousButton) {
            this.setImageIndex(this.imageIndex == 0 ? 0 : this.imageIndex - 1);
        } else if (event.widget == this.nextButton) {
            this.setImageIndex(this.imageIndex == this.singleImages.length ? this.singleImages.length : this.imageIndex + 1);
        } else if (event.widget == this.lastButton) {
            this.setImageIndex(this.singleImages.length);
        }
        this.updateImageButtons();
        this.initPreviewImageRatio();
    }

    private void updateImageButtons() {
        this.firstButton.setData(ENABLED, (Object)(this.singleImages != null && this.imageIndex != 0 ? 1 : 0));
        this.previousButton.setData(ENABLED, (Object)(this.singleImages != null && this.imageIndex != 0 ? 1 : 0));
        this.nextButton.setData(ENABLED, (Object)(this.singleImages != null && this.imageIndex != this.singleImages.length ? 1 : 0));
        this.lastButton.setData(ENABLED, (Object)(this.singleImages != null && this.imageIndex != this.singleImages.length ? 1 : 0));
        this.updateButtonImages();
    }

    public void disableImageButtons() {
        this.firstButton.setData(ENABLED, (Object)false);
        this.previousButton.setData(ENABLED, (Object)false);
        this.nextButton.setData(ENABLED, (Object)false);
        this.lastButton.setData(ENABLED, (Object)false);
        this.updateButtonImages();
    }

    private void updateButtonImages() {
        this.firstButton.setImage(this.getIcon("nav_first.png", Boolean.TRUE.equals(this.firstButton.getData(ENABLED))));
        this.previousButton.setImage(this.getIcon("nav_previous.png", Boolean.TRUE.equals(this.previousButton.getData(ENABLED))));
        this.nextButton.setImage(this.getIcon("nav_next.png", Boolean.TRUE.equals(this.nextButton.getData(ENABLED))));
        this.lastButton.setImage(this.getIcon("nav_last.png", Boolean.TRUE.equals(this.lastButton.getData(ENABLED))));
    }

    public void setPrefSize(Point prefSize) {
        if (prefSize == null || prefSize.x == this.getPrefWidth() && prefSize.y == this.getPrefHeight()) {
            return;
        }
        int oldPrefWidth = this.prefWidth;
        int oldPrefHeight = this.prefHeight;
        this.prefWidth = prefSize.x;
        this.prefHeight = prefSize.y;
        org.eclipse.swt.layout.GridData gridData = (org.eclipse.swt.layout.GridData)this.canvas.getLayoutData();
        gridData.widthHint = this.getPrefWidth() + 1 + 1;
        gridData.heightHint = this.getPrefHeight() + 1 + 1;
        this.updatePrefSize(oldPrefWidth, oldPrefHeight);
    }

    public void updateBackgroundImageComposite(boolean showDetails, boolean landscape) {
        String backgroundImageName = showDetails ? (landscape ? "paper-details-landscape.png" : "paper-details-portrait.png") : (landscape ? "paper-simple-landscape.png" : "paper-simple-portrait.png");
        this.backgroundImage = MindMapUI.getImages().get("icons/pages/" + backgroundImageName).createImage();
    }

    public void updateBackgroundImage() {
        if (this.imageIndex != 0) {
            if (this.backgroundImageComposite.getBackgroundImage() == this.backgroundImage) {
                return;
            }
            this.backgroundImageComposite.setBackgroundImage(this.backgroundImage);
            org.eclipse.swt.layout.GridData layoutData = (org.eclipse.swt.layout.GridData)this.backgroundImageComposite.getLayoutData();
            layoutData.widthHint = this.backgroundImageComposite.getBackgroundImage().getBounds().width;
            layoutData.heightHint = this.backgroundImageComposite.getBackgroundImage().getBounds().height;
        } else {
            this.backgroundImageComposite.setBackgroundImage(null);
            org.eclipse.swt.layout.GridData layoutData = (org.eclipse.swt.layout.GridData)this.backgroundImageComposite.getLayoutData();
            layoutData.widthHint = -1;
            layoutData.heightHint = -1;
        }
        this.backgroundImageComposite.getShell().pack();
        this.backgroundImageComposite.getShell().layout(true, true);
    }

    private void updateCanvas() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setEnabled(this.getImage() != null);
        }
    }

    private void hookCanvas(Canvas canvas, Listener listener) {
        canvas.addListener(9, listener);
        canvas.addListener(12, listener);
    }

    private void handleCanvasEvent(Event event) {
        switch (event.type) {
            case 9: {
                this.paintCanvas(event);
                break;
            }
            case 12: {
                this.handleWidgetDisposed();
            }
        }
    }

    private void handleWidgetDisposed() {
        if (this.wholeImage != null && !this.wholeImage.isDisposed()) {
            this.wholeImage.dispose();
        }
        if (this.singleImages != null) {
            Image[] imageArray = this.singleImages;
            int n = this.singleImages.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                ++n2;
            }
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
    }

    private void paintCanvas(Event event) {
        GC gc = event.gc;
        org.eclipse.swt.graphics.Rectangle area = this.canvas.getClientArea();
        gc.setClipping(area);
        this.drawImage(gc, area);
        this.drawTitle(gc, area);
        gc.setClipping(area);
        gc.setForeground(event.display.getSystemColor(15));
        this.canvas.getViewport().paint((Graphics)new SWTGraphics(gc));
    }

    private void drawTitle(GC gc, org.eclipse.swt.graphics.Rectangle area) {
        if (this.title == null) {
            return;
        }
        gc.setFont(this.composite.getFont());
        gc.setForeground(this.composite.getForeground());
        Point size = gc.stringExtent(this.title);
        int x = (this.titlePlacement & 0x4000) != 0 ? area.x + 3 : ((this.titlePlacement & 0x20000) != 0 ? area.x + area.width - size.x - 3 : area.x + (area.width - size.x) / 2);
        int y = (this.titlePlacement & 0x80) != 0 ? area.y + 3 : ((this.titlePlacement & 0x400) != 0 ? area.y + area.height - size.y - 3 : area.y + (area.height - size.y) / 2);
        gc.drawString(this.title, x, y, true);
    }

    private void drawImage(GC gc, org.eclipse.swt.graphics.Rectangle area) {
        if (this.image != null && !this.image.isDisposed()) {
            this.drawImage(gc, area, this.image, this.image.getBounds());
        }
    }

    private void drawImage(GC gc, org.eclipse.swt.graphics.Rectangle area, Image image, org.eclipse.swt.graphics.Rectangle imgSize) {
        double srcWidth = Math.min((double)imgSize.width, (double)area.width / this.ratio);
        double srcHeight = Math.min((double)imgSize.height, (double)area.height / this.ratio);
        double srcX = Math.max(0.0, Math.min((double)imgSize.width - srcWidth, this.x));
        double srcY = Math.max(0.0, Math.min((double)imgSize.height - srcHeight, this.y));
        double destWidth = srcWidth * this.ratio;
        double destHeight = srcHeight * this.ratio;
        double destX = (double)(area.x + 1) + ((double)(area.width - 1 - 1) - destWidth) / 2.0;
        double destY = (double)(area.y + 1) + ((double)(area.height - 1 - 1) - destHeight) / 2.0;
        gc.setAntialias(1);
        gc.drawImage(image, (int)srcX, (int)srcY, (int)srcWidth, (int)srcHeight, (int)destX, (int)destY, (int)destWidth, (int)destHeight);
    }

    public void setPrefWidth(int prefWidth) {
        if (prefWidth == this.prefWidth) {
            return;
        }
        int oldPrefWidth = this.prefWidth;
        this.prefWidth = prefWidth;
        this.updatePrefSize(oldPrefWidth, this.getPrefHeight());
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefHeight(int prefHeight) {
        if (prefHeight == this.prefHeight) {
            return;
        }
        int oldPrefHeight = this.prefHeight;
        this.prefHeight = prefHeight;
        this.updatePrefSize(this.getPrefWidth(), oldPrefHeight);
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    private void updatePrefSize(int oldPrefWidth, int oldPrefHeight) {
        if (this.calculatePrefRatio() != 0.0) {
            this.changeRatio(this.calculatePrefRatio(), oldPrefWidth, oldPrefHeight);
        }
    }

    private double calculatePrefRatio() {
        if (this.image != null && !this.image.isDisposed()) {
            org.eclipse.swt.graphics.Rectangle imgSize = this.image.getBounds();
            double horizontalRatio = (double)this.getPrefWidth() / (double)imgSize.width;
            double verticalRatio = (double)this.getPrefHeight() / (double)imgSize.height;
            return Math.min(horizontalRatio, verticalRatio);
        }
        return 0.0;
    }

    private void setRatio(double ratio) {
        this.ratio = ratio;
        this.calculateFigureBorder();
    }

    private double getRatio() {
        return this.ratio;
    }

    private void setX(double x) {
        this.x = x;
    }

    private void setY(double y) {
        this.y = y;
    }

    public Control getControl() {
        return this.composite;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setFocus() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setFocus();
        }
    }

    public void changeRatio(double ratio) {
        this.changeRatio(ratio, this.getPrefWidth(), this.getPrefHeight());
    }

    private void changeRatio(double ratio, int oldPrefWidth, int oldPrefHeight) {
        double oldRatio = this.ratio;
        this.setRatio(ratio);
        double newRatio = this.ratio;
        if (this.image != null) {
            org.eclipse.swt.graphics.Rectangle imgSize = this.image.getBounds();
            double oldWidth = Math.min((double)imgSize.width, (double)oldPrefWidth / oldRatio);
            double oldHeight = Math.min((double)imgSize.height, (double)oldPrefHeight / oldRatio);
            double oldCenterX = this.x + oldWidth / 2.0;
            double oldCenterY = this.y + oldHeight / 2.0;
            double newWidth = Math.min((double)imgSize.width, (double)this.getPrefWidth() / newRatio);
            double newHeight = Math.min((double)imgSize.height, (double)this.getPrefHeight() / newRatio);
            this.setX(Math.min((double)imgSize.width - newWidth, Math.max(0.0, oldCenterX - newWidth / 2.0)));
            this.setY(Math.min((double)imgSize.height - newHeight, Math.max(0.0, oldCenterY - newHeight / 2.0)));
        }
        this.updateFontHeight();
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setImage(Image image) {
        if (image != null && !image.isDisposed()) {
            org.eclipse.swt.graphics.Rectangle imgSize = image.getBounds();
            this.setImage(image, imgSize.x + imgSize.width / 2, imgSize.y + imgSize.height / 2);
        } else {
            this.setImage(null, 0.0, 0.0);
        }
    }

    public void setImage(Image image, double centerX, double centerY) {
        this.image = image;
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle imgSize = image.getBounds();
            double horizontalRatio = (double)this.getPrefWidth() / (double)imgSize.width;
            double verticalRatio = (double)this.getPrefHeight() / (double)imgSize.height;
            this.setRatio(Math.min(horizontalRatio, verticalRatio));
            double width = Math.min((double)imgSize.width, (double)this.getPrefWidth() / this.getRatio());
            double height = Math.min((double)imgSize.height, (double)this.getPrefHeight() / this.getRatio());
            this.setX(Math.max(0.0, Math.min((double)imgSize.width - width, centerX - width / 2.0)));
            this.setY(Math.max(0.0, Math.min((double)imgSize.height - height, centerY - height / 2.0)));
        }
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
        this.updateCanvas();
    }

    public Image getImage() {
        return this.image;
    }

    public void setTitle(String title) {
        if (title == this.title || title != null && title.equals(this.title)) {
            return;
        }
        this.title = title;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitlePlacement(int titlePlacement) {
        if (titlePlacement == this.titlePlacement) {
            return;
        }
        this.titlePlacement = titlePlacement;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public int getTitlePlacement() {
        return this.titlePlacement;
    }

    public void setWholeImage(Image wholeImage) {
        if (this.wholeImage != null) {
            this.wholeImage.dispose();
        }
        this.wholeImage = wholeImage;
    }

    public void setSingleImages(Image[] singleImages) {
        if (this.singleImages != null) {
            Image[] imageArray = this.singleImages;
            int n = this.singleImages.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
        }
        this.singleImages = singleImages;
        this.totalPagesLabel.setText("" + singleImages.length);
        this.totalPagesLabel.getParent().getParent().layout();
    }

    private void calculateFigureBorder() {
        if (this.singleImages == null || this.singleImages.length == 0 || this.singleImages[0] == null || this.singleImages[0].isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle area = this.canvas.getClientArea();
        if (this.imageBorderBounds != null) {
            this.borderFigure.setBounds(new Rectangle((int)((double)this.imageBorderBounds.x * this.ratio), (int)((double)this.imageBorderBounds.y * this.ratio), (int)((double)this.imageBorderBounds.width * this.ratio + 2.0), (int)((double)this.imageBorderBounds.height * this.ratio + 1.0)));
        }
        this.textLayer.setBounds(new Rectangle(0, 0, area.width, area.height));
        ((IFigure)this.textLayer.getChildren().get(0)).revalidate();
    }

    public void initPreviewImageRatio() {
        if (this.getImage() != null && !this.getImage().isDisposed()) {
            double heightRatio;
            double widthRatio = (double)this.getPrefWidth() / (double)this.getImage().getBounds().width;
            double ratio = widthRatio < (heightRatio = (double)this.getPrefHeight() / (double)this.getImage().getBounds().height) ? widthRatio : heightRatio;
            this.changeRatio(ratio);
        }
    }

    public void setImageIndex(int imageIndex) {
        this.feedbackLayer.setVisible(imageIndex != 0);
        this.imageIndex = imageIndex;
        this.pageNumberLabel.setText("" + imageIndex);
        this.pageNumberLabel.getParent().getParent().layout();
        String pageNumber = imageIndex == 0 ? "" : "- " + imageIndex + " -";
        this.updatePageNumber(pageNumber);
        this.updateImageButtons();
        this.updateBackgroundImage();
        Image image = imageIndex == 0 ? this.wholeImage : this.singleImages[imageIndex - 1];
        this.setImage(image);
    }

    private void updatePageNumber(String text) {
        if (this.pageNumberFigure != null) {
            this.pageNumberFigure.setText(text);
            Font font = Display.getCurrent().getSystemFont();
            int height = font.getFontData()[0].getHeight();
            font = FontUtils.getNewHeight((Font)font, (int)((int)((double)height * this.getFontRatio() * 4.0)));
            this.pageNumberFigure.setFont(font);
            this.pageNumberFigure.setVisible(!"".equals(text));
            this.pageNumberFigure.revalidate();
            this.canvas.layout();
        }
    }

    private double getFontRatio() {
        double heightRatio;
        double widthRatio;
        if (this.image == null) {
            return this.ratio;
        }
        org.eclipse.swt.graphics.Rectangle bounds = this.image.getBounds();
        int pageWidth = 1403;
        int pageHeight = 992;
        if (bounds.width < bounds.height) {
            pageWidth = 992;
            pageHeight = 1403;
        }
        return (widthRatio = (double)this.getPrefWidth() / (double)pageWidth) < (heightRatio = (double)this.getPrefHeight() / (double)pageHeight) ? widthRatio : heightRatio;
    }

    public void setImageBorderBounds(org.eclipse.swt.graphics.Rectangle bounds) {
        this.imageBorderBounds = new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void updateHeaderPreview(String text, String alignValue, int defaultDraw2DAlign, String fontValue) {
        this.updateHFPreview(text, alignValue, defaultDraw2DAlign, fontValue, this.headerFigure);
    }

    public void updateFooterPreview(String text, String alignValue, int defaultDraw2DAlign, String fontValue) {
        this.updateHFPreview(text, alignValue, defaultDraw2DAlign, fontValue, this.footerFigure);
    }

    private void updateHFPreview(String text, String alignValue, int defaultDraw2DAlign, String fontValue, ITextFigure textFigure) {
        if (textFigure != null) {
            textFigure.setText(text);
            textFigure.setTextAlignment(PrintConstants.toDraw2DAlignment(alignValue, defaultDraw2DAlign));
            Font font = null;
            if (fontValue != null) {
                font = FontUtils.getFont((String)fontValue);
            }
            if (font == null) {
                font = Display.getCurrent().getSystemFont();
            }
            if (textFigure == this.headerFigure) {
                this.headerFont = font;
            } else {
                this.footerFont = font;
            }
            int height = font.getFontData()[0].getHeight();
            font = FontUtils.getNewHeight((Font)font, (int)((int)((double)height * this.getFontRatio() * 4.0)));
            textFigure.setFont(font);
            textFigure.setVisible(!"".equals(text));
            textFigure.revalidate();
            this.canvas.layout();
        }
    }

    public void setFeedbackVisible(boolean visible) {
        if (this.feedbackLayer != null) {
            this.feedbackLayer.setVisible(visible);
        }
    }

    public void setBorderVisible(boolean visible) {
        if (this.borderFigure != null) {
            this.borderFigure.setVisible(visible);
            this.canvas.layout();
        }
    }

    public void setPageNumberVisible(boolean visible) {
        if (this.pageNumberLayer != null) {
            this.pageNumberLayer.setVisible(visible);
            this.canvas.layout();
        }
    }

    private void updateFontHeight() {
        this.setFontHeightToPreview((IFigure)this.headerFigure);
        this.setFontHeightToPreview((IFigure)this.footerFigure);
        this.setFontHeightToPreview((IFigure)this.pageNumberFigure);
    }

    private void setFontHeightToPreview(IFigure target) {
        Font font;
        if (target == null) {
            return;
        }
        Font font2 = target == this.pageNumberFigure ? Display.getCurrent().getSystemFont() : (font = target == this.headerFigure ? this.headerFont : this.footerFont);
        if (font == null) {
            return;
        }
        int height = font.getFontData()[0].getHeight();
        font = FontUtils.getNewHeight((Font)font, (int)((int)((double)height * this.getFontRatio() * 4.0)));
        target.setFont(font);
    }

    private Image getIcon(String path, boolean enabled) {
        return (Image)this.resources.get((DeviceResourceDescriptor)MindMapUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui", (String)("icons/nav/" + (enabled ? "e/" : "d/") + path)));
    }

    private class PreviewTextLayout
    extends AbstractLayout {
        private PreviewTextLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return container.getSize();
        }

        public void layout(IFigure container) {
            int y;
            Dimension size;
            Rectangle area = container.getClientArea();
            Rectangle borderBounds = MultipageImagePreviewViewer.this.borderFigure.getBounds();
            int textMargin = Util.isMac() ? 5 : 0;
            int bottomDownValue = 4;
            if (MultipageImagePreviewViewer.this.pageNumberLayer != null) {
                size = MultipageImagePreviewViewer.this.pageNumberLayer.getPreferredSize(-1, -1);
                y = area.y + area.height - size.height - Math.max((area.y + area.height - (borderBounds.y + borderBounds.height) - size.height) / 2, textMargin) + bottomDownValue;
                int x = area.x + (area.width - size.width) / 2;
                MultipageImagePreviewViewer.this.pageNumberLayer.setBounds(new Rectangle(x, y, area.width, size.height));
            }
            if (MultipageImagePreviewViewer.this.headerFigure != null) {
                size = MultipageImagePreviewViewer.this.headerFigure.getPreferredSize(area.width, -1);
                y = area.y + Math.max((borderBounds.y - area.y - size.height) / 2, textMargin);
                MultipageImagePreviewViewer.this.headerFigure.setBounds(new Rectangle(area.x, y, area.width, size.height));
            }
            if (MultipageImagePreviewViewer.this.footerFigure != null) {
                size = MultipageImagePreviewViewer.this.footerFigure.getPreferredSize(area.width, -1);
                y = area.y + area.height - size.height - Math.max((area.y + area.height - (borderBounds.y + borderBounds.height) - size.height) / 2, textMargin) + bottomDownValue;
                MultipageImagePreviewViewer.this.footerFigure.setBounds(new Rectangle(area.x, y, area.width, size.height));
            }
        }
    }
}

