/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.xmind.gef.Request;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.prefs.PrefMessages;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.properties.StyledPropertySectionPart;

public class SheetAdvancedStylePropertySectionPart
extends StyledPropertySectionPart {
    private Button taperedLinesCheck;
    private Button gradientColorCheck;

    @Override
    protected void createContent(Composite parent) {
        this.taperedLinesCheck = new Button(parent, 32);
        this.taperedLinesCheck.setText(PropertyMessages.TaperedLines_text);
        this.taperedLinesCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ToggleTaperedlineCount");
                SheetAdvancedStylePropertySectionPart.this.changeTaperedLines();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.gradientColorCheck = new Button(parent, 32);
        this.gradientColorCheck.setText(PrefMessages.EditorPage_UndoRedo_gradientColor);
        this.gradientColorCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ToggleGradientColorCount");
                SheetAdvancedStylePropertySectionPart.this.changeGradientColor();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void changeGradientColor() {
        Request request = this.createStyleRequest(CommandMessages.Command_ToggleGradientColor);
        if (this.gradientColorCheck.getSelection()) {
            this.addStyle(request, "color-gradient", "gradient");
        } else {
            this.addStyle(request, "color-gradient", "none");
        }
        this.sendRequest(request);
    }

    private void changeTaperedLines() {
        Request request = this.createStyleRequest(CommandMessages.Command_ToggleTaperedLines);
        if (this.taperedLinesCheck.getSelection()) {
            this.addStyle(request, "line-tapered", "tapered");
        } else {
            this.addStyle(request, "line-tapered", "none");
        }
        this.sendRequest(request);
    }

    @Override
    protected void doRefresh() {
        if (this.taperedLinesCheck != null && !this.taperedLinesCheck.isDisposed()) {
            String value = this.getStyleValue("line-tapered", null);
            this.taperedLinesCheck.setSelection(value != null && !"none".equals(value));
        }
        if (this.gradientColorCheck != null && !this.gradientColorCheck.isDisposed()) {
            boolean hasGradient = MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("gradientColor");
            String value = this.getStyleValue("color-gradient", null);
            if ("none".equals(value)) {
                hasGradient = false;
            } else if ("gradient".equals(value)) {
                hasGradient = true;
            }
            this.gradientColorCheck.setSelection(hasGradient);
        }
    }

    public void dispose() {
        super.dispose();
        this.taperedLinesCheck = null;
        this.gradientColorCheck = null;
    }

    public void setFocus() {
        this.taperedLinesCheck.setFocus();
    }
}

