/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IBendPointsFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.internal.tools.FeedbackResizeTool;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.ITopicPart;

public class RangeResizeTool
extends FeedbackResizeTool
implements ISourceTool {
    private Set<IBranchPart> newRange;
    private IBranchPart parentBranch;
    private int minLength;
    private int maxLength;
    private IBranchRangePart source;

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof IBranchRangePart));
        this.source = (IBranchRangePart)source;
        this.parentBranch = this.source.getOwnedBranch();
        this.newRange = new HashSet<IBranchPart>(this.source.getEnclosingBranches());
    }

    public IGraphicalEditPart getSource() {
        return (IGraphicalEditPart)this.source;
    }

    public IBranchRangePart getRangeSourcePart() {
        return this.source;
    }

    @Override
    protected Rectangle getSourceArea() {
        return this.getSource().getFigure().getBounds();
    }

    @Override
    protected IFeedback getSourceFeedback() {
        return (IFeedback)this.getSource().getAdapter(IFeedback.class);
    }

    @Override
    protected void initFeedback(IBendPointsFeedback feedback) {
        super.initFeedback(feedback);
        this.minLength = this.calcMinLength(this.getOrientation());
        this.maxLength = this.calcMaxLength(this.getOrientation());
        this.updateRange(this.getResultArea());
    }

    protected int calcMaxLength(int orientation) {
        Rectangle parentBounds = this.parentBranch.getFigure().getBounds();
        Insets insets = this.getRangeSourcePart().getFigure().getInsets();
        if (orientation == 4) {
            return parentBounds.bottom() - this.getInitArea().y + insets.bottom;
        }
        if (orientation == 1) {
            return this.getInitArea().bottom() - parentBounds.y + insets.top;
        }
        if (orientation == 8) {
            return this.getInitArea().right() - parentBounds.x + insets.left;
        }
        return parentBounds.right() - this.getInitArea().x + insets.right;
    }

    protected int calcMinLength(int orientation) {
        ITopicPart topicPart;
        int length = 3;
        IBranchPart last = this.calcLastBranch(orientation);
        if (last != null && (topicPart = last.getTopicPart()) != null) {
            length = orientation == 4 || orientation == 1 ? (length += topicPart.getFigure().getBounds().height) : (length += topicPart.getFigure().getBounds().width);
        }
        length = orientation == 4 ? (length += this.getRangeSourcePart().getFigure().getInsets().top) : (orientation == 1 ? (length += this.getRangeSourcePart().getFigure().getInsets().bottom) : (orientation == 8 ? (length += this.getRangeSourcePart().getFigure().getInsets().right) : (length += this.getRangeSourcePart().getFigure().getInsets().left)));
        return length;
    }

    private IBranchPart calcLastBranch(int orientation) {
        List<IBranchPart> enclosingBranches = this.getRangeSourcePart().getEnclosingBranches();
        if (enclosingBranches.isEmpty()) {
            return null;
        }
        IStructure structure = this.parentBranch.getBranchPolicy().getStructure(this.parentBranch);
        if (structure instanceof IBranchStructureExtension) {
            int direction = ((IBranchStructureExtension)structure).getRangeGrowthDirection(this.parentBranch, this.getRangeSourcePart());
            if (direction == orientation) {
                return this.first(enclosingBranches);
            }
            if (direction == Geometry.getOppositePosition((int)orientation)) {
                return this.last(enclosingBranches);
            }
        }
        return null;
    }

    private IBranchPart first(List<IBranchPart> branches) {
        return branches.get(0);
    }

    private IBranchPart last(List<IBranchPart> branches) {
        return branches.get(branches.size() - 1);
    }

    protected void updateAreaBounds(Rectangle area, Point cursorPosition) {
        super.updateAreaBounds(area, cursorPosition);
        Rectangle resultArea = this.getResultArea();
        this.updateRange(resultArea);
        this.addMissingBranches();
    }

    private void updateRange(Rectangle area) {
        for (IBranchPart branch : this.parentBranch.getSubBranches()) {
            ITopicPart topicPart = branch.getTopicPart();
            if (topicPart == null) continue;
            Point pt = topicPart.getFigure().getBounds().getCenter();
            if (area.contains(pt)) {
                this.newRange.add(branch);
                topicPart.getStatus().preSelect();
                continue;
            }
            this.newRange.remove(branch);
            topicPart.getStatus().dePreSelect();
        }
    }

    private void addMissingBranches() {
        List<IBranchPart> subBranches = this.parentBranch.getSubBranches();
        ArrayList<Integer> optedBranches = null;
        int i = 0;
        while (i < subBranches.size()) {
            boolean preSelected;
            IBranchPart subBranch = subBranches.get(i);
            ITopicPart topicPart = subBranch.getTopicPart();
            if (topicPart != null && (preSelected = topicPart.getStatus().isPreSelected())) {
                if (optedBranches == null) {
                    optedBranches = new ArrayList<Integer>();
                }
                optedBranches.add(i);
            }
            ++i;
        }
        int j = (Integer)optedBranches.get(0);
        while (j <= (Integer)optedBranches.get(optedBranches.size() - 1)) {
            boolean preSelected;
            ITopicPart topicPart = subBranches.get(j).getTopicPart();
            if (topicPart != null && !(preSelected = topicPart.getStatus().isPreSelected())) {
                topicPart.getStatus().preSelect();
            }
            ++j;
        }
    }

    @Override
    protected void removeFeedback(IBendPointsFeedback feedback) {
        super.removeFeedback(feedback);
        this.clearRange();
    }

    public void finish() {
        ArrayList<Object> range = new ArrayList<Object>(this.newRange);
        super.finish();
        this.sendRequest(range);
    }

    private void sendRequest(List<Object> newRange) {
        IBranchRangePart rangeSource = this.getRangeSourcePart();
        Request request = new Request("modify_range");
        request.setViewer((IViewer)this.getTargetViewer());
        request.setPrimaryTarget((IPart)rangeSource);
        request.setParameter("range", (Object)newRange.toArray());
        this.getDomain().handleRequest(request);
    }

    private void clearRange() {
        for (IBranchPart branch : this.parentBranch.getSubBranches()) {
            ITopicPart topicPart = branch.getTopicPart();
            if (topicPart == null) continue;
            topicPart.getStatus().dePreSelect();
        }
        this.newRange = null;
    }

    protected int constrainWidth(int w) {
        if (this.getOrientation() == 16 || this.getOrientation() == 8) {
            return Math.max(Math.min(w, this.maxLength), this.minLength);
        }
        return super.constrainWidth(w);
    }

    protected int constrainHeight(int h) {
        if (this.getOrientation() == 1 || this.getOrientation() == 4) {
            return Math.max(Math.min(h, this.maxLength), this.minLength);
        }
        return super.constrainHeight(h);
    }
}

