/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IBoundary;
import org.xmind.core.INumbering;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.core.ISummary;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.core.ITopicRange;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Point;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.branch.IFreeableBranchStructureExtension;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.IIconTipPart;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.IViewerModel;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ImageUtils;

public class MindMapUtils {
    private static final List<IPart> NO_PARTS = Collections.emptyList();
    private static final String NUMBER_SEPARATOR = ".";

    protected MindMapUtils() {
    }

    public static Object toRealModel(Object model) {
        if (model instanceof IViewerModel) {
            return ((IViewerModel)model).getRealModel();
        }
        if (model instanceof IMindMap) {
            return ((IMindMap)model).getSheet();
        }
        return model;
    }

    public static Object getRealModel(IPart part) {
        return MindMapUtils.toRealModel(part.getModel());
    }

    public static List<Object> getRealModels(List<? extends IPart> parts) {
        ArrayList<Object> models = new ArrayList<Object>(parts.size());
        for (IPart iPart : parts) {
            Object m = MindMapUtils.getRealModel(iPart);
            if (m == null || models.contains(m)) continue;
            models.add(m);
        }
        return models;
    }

    public static List<ITopic> getTopics(List<? extends IPart> parts) {
        ArrayList<ITopic> topics = new ArrayList<ITopic>(parts.size());
        for (IPart iPart : parts) {
            Object model = MindMapUtils.getRealModel(iPart);
            if (!(model instanceof ITopic) || topics.contains(model)) continue;
            topics.add((ITopic)model);
        }
        return topics;
    }

    public static List<IPart> getParts(List<?> models, IViewer viewer) {
        ArrayList<IPart> parts = new ArrayList<IPart>(models.size());
        for (Object model : models) {
            IPart p = viewer.findPart(model);
            if (p == null || parts.contains(p)) continue;
            parts.add(p);
        }
        return parts;
    }

    public static boolean isSingleTopic(ISelection selection) {
        return MindMapUtils.matchesSelection(selection, "org.xmind.ui.topic", true);
    }

    public static boolean isSingle(ISelection selection, String category) {
        return MindMapUtils.matchesSelection(selection, category, true);
    }

    public static boolean hasSuchElements(ISelection selection, String category) {
        return MindMapUtils.matchesSelection(selection, category, false);
    }

    public static boolean matchesSelection(ISelection selection, String category, boolean singleOrMultiple) {
        if (selection == null || category == null || selection.isEmpty()) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (singleOrMultiple) {
                Object o;
                if (ss.size() == 1 && MindMapUtils.isThisCategory(o = ss.getFirstElement(), category)) {
                    return true;
                }
            } else {
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (MindMapUtils.isThisCategory(o, category)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private static boolean isThisCategory(Object o, String category) {
        return MindMapUI.getCategoryManager().belongsToCategory(o, category);
    }

    public static boolean isAllSuchElements(ISelection selection, String category) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!MindMapUtils.isThisCategory(o, category)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static List<Object> getAllSuchElements(ISelection selection, String category) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (MindMapUtils.isThisCategory(o, category)) {
                    list.add(o);
                }
                ++n2;
            }
        }
        return list;
    }

    public static boolean hasCentralTopic(ISelection selection, IViewer viewer) {
        if (selection == null || selection.isEmpty() || viewer == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o.equals(viewer.getAdapter(ITopic.class))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean hasSummary(ISelection selection, IViewer viewer) {
        if (selection == null || selection.isEmpty() || viewer == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITopic && "summary".equals(((ITopic)o).getType())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isPropertyModifiable(ISelection selection, String propName, IViewer viewer) {
        if (selection == null || propName == null || viewer == null || selection.isEmpty()) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            boolean hasTopic = false;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITopic) {
                    hasTopic = true;
                    IBranchPart branch = MindMapUtils.findBranch(viewer.findPart(o));
                    if (branch == null || !branch.isPropertyModifiable(propName)) {
                        return false;
                    }
                }
                ++n2;
            }
            if (hasTopic) {
                return true;
            }
        }
        return false;
    }

    public static IBranchPart findBranch(IPart source) {
        if (source == null) {
            return null;
        }
        if (source instanceof IBranchPart) {
            return (IBranchPart)source;
        }
        IPart parent = source.getParent();
        if (parent == null) {
            return null;
        }
        return MindMapUtils.findBranch(parent);
    }

    public static ITopicPart findTopicPart(IPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return (ITopicPart)part.getAdapter(ITopicPart.class);
    }

    public static List<IPart> getSequenceTopics(IPart start, IPart end) {
        List<IBranchPart> branches;
        IBranchPart startBranch = MindMapUtils.findBranch(start);
        IBranchPart endBranch = MindMapUtils.findBranch(end);
        if (startBranch == null || endBranch == null) {
            return NO_PARTS;
        }
        IPart parent = startBranch.getParent();
        if (parent == null || parent != endBranch.getParent()) {
            return NO_PARTS;
        }
        if (parent instanceof IBranchPart) {
            branches = ((IBranchPart)parent).getSubBranches();
        } else if (parent instanceof ISheetPart) {
            branches = ((ISheetPart)parent).getFloatingBranches();
        } else {
            return NO_PARTS;
        }
        int startIndex = branches.indexOf(startBranch);
        int endIndex = branches.indexOf(endBranch);
        if (startIndex < 0 || endIndex < 0) {
            return NO_PARTS;
        }
        if (endIndex < startIndex) {
            int temp = endIndex;
            endIndex = startIndex;
            startIndex = temp;
        }
        ArrayList<IPart> parts = new ArrayList<IPart>(endIndex - startIndex + 1);
        int i = startIndex;
        while (i <= endIndex) {
            IPart p = (IPart)branches.get(i);
            if (p instanceof IBranchPart) {
                parts.add((IPart)((IBranchPart)p).getTopicPart());
            }
            ++i;
        }
        return parts;
    }

    public static boolean isTopicTextChar(char c) {
        if (Character.isISOControl(c)) {
            return false;
        }
        return c != '+' && c != '-' && c != '*' && c != '/';
    }

    public static org.eclipse.draw2d.geometry.Point toGraphicalPosition(Point modelPosition) {
        if (modelPosition == null) {
            return null;
        }
        return new org.eclipse.draw2d.geometry.Point(modelPosition.x, modelPosition.y);
    }

    public static Point toModelPosition(org.eclipse.draw2d.geometry.Point graphicalPosition) {
        if (graphicalPosition == null) {
            return null;
        }
        return new Point(graphicalPosition.x, graphicalPosition.y);
    }

    public static String getText(Object element) {
        return MindMapUtils.getText(element, "");
    }

    public static String getText(Object element, String defaultText) {
        if (element instanceof ITitled) {
            return ((ITitled)element).getTitleText();
        }
        if (element instanceof IWorkbook) {
            return MindMapMessages.TitleText_Workbook;
        }
        return defaultText;
    }

    public static ImageDescriptor getImageDescriptor(Object element) {
        return MindMapUI.getImages().getElementIcon(element, true);
    }

    public static Image getImage(Object element) {
        return ImageUtils.getImage((ImageDescriptor)MindMapUtils.getImageDescriptor(element));
    }

    public static IPart findToFocus(List<IPart> sources, IViewer viewer) {
        IPart focusedPart;
        IPart toFocus = null;
        if (viewer != null && (focusedPart = viewer.getFocusedPart()) != null) {
            toFocus = MindMapUtils.findToFocus(focusedPart, sources, viewer);
        }
        return toFocus;
    }

    private static IPart findToFocus(IPart currentFocus, List<IPart> sources, IViewer viewer) {
        Object model = MindMapUtils.getRealModel(currentFocus);
        List<Object> models = MindMapUtils.getRealModels(sources);
        if (models.contains(model)) {
            IPart p;
            ITopic topic;
            if (model instanceof ITopic) {
                return MindMapUtils.findTopicToFocus((ITopic)model, models, viewer);
            }
            if (model instanceof IRelationship) {
                IPart p2;
                IRelationship r = (IRelationship)model;
                IRelationshipEnd end = r.getEnd2();
                if (end == null) {
                    end = r.getEnd1();
                }
                if (end != null && (p2 = viewer.findPart((Object)end)) != null) {
                    return p2;
                }
            } else if (model instanceof ITopicComponent && (topic = ((ITopicComponent)model).getParent()) != null && (p = viewer.findPart((Object)topic)) != null) {
                return p;
            }
        }
        return null;
    }

    private static IPart findTopicToFocus(ITopic t, List<Object> models, IViewer viewer) {
        ITopic p = t.getParent();
        if (p != null) {
            IPart tp;
            ITopic topicToFocus = null;
            while (p != null && topicToFocus == null) {
                int index = t.getIndex();
                List children = p.getChildren(t.getType());
                int i = index;
                while (i >= 0) {
                    t = (ITopic)children.get(i);
                    if (!models.contains(t)) {
                        topicToFocus = t;
                        break;
                    }
                    --i;
                }
                if (topicToFocus == null) {
                    i = index;
                    while (i < children.size()) {
                        t = (ITopic)children.get(i);
                        if (!models.contains(t)) {
                            topicToFocus = t;
                            break;
                        }
                        ++i;
                    }
                }
                if (topicToFocus != null) continue;
                t = p;
                p = t.getParent();
            }
            if (topicToFocus == null && t != null && !models.contains(t)) {
                topicToFocus = t;
            }
            if (topicToFocus != null && (tp = viewer.findPart(topicToFocus)) != null) {
                return tp;
            }
        }
        return null;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isAncestorInList(ITopic topic, Collection<? extends Object> topics) {
        ITopic parent = topic.getParent();
        if (parent == null) {
            return false;
        }
        if (topics.contains(parent)) {
            return true;
        }
        return MindMapUtils.isAncestorInList(parent, topics);
    }

    public static boolean isDescendentOf(ITopic topic, ITopic ancestor) {
        ITopic parent = topic.getParent();
        if (parent == null) {
            return false;
        }
        if (ancestor.equals(parent)) {
            return true;
        }
        return MindMapUtils.isDescendentOf(parent, ancestor);
    }

    public static List<ITopic> filterOutDescendents(List<ITopic> topics, ITopic root) {
        Iterator<ITopic> it = topics.iterator();
        while (it.hasNext()) {
            ITopic t = it.next();
            if (!MindMapUtils.isAncestorInList(t, topics) && (root == null || MindMapUtils.isDescendentOf(t, root))) continue;
            it.remove();
        }
        return topics;
    }

    public static Set<ITopicRange> findContainedRanges(Collection<ITopic> topics, boolean checkSummary, boolean checkBoundary) {
        HashSet<ITopicRange> ranges = new HashSet<ITopicRange>();
        if (!checkSummary && !checkBoundary) {
            return ranges;
        }
        HashSet<ITopic> parents = new HashSet<ITopic>();
        for (ITopic t : topics) {
            ITopic parent = t.getParent();
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            if (checkSummary) {
                for (ISummary s : parent.getSummaries()) {
                    if (!topics.containsAll(s.getEnclosingTopics())) continue;
                    ranges.add((ITopicRange)s);
                }
            }
            if (!checkBoundary) continue;
            for (IBoundary b : parent.getBoundaries()) {
                if (!topics.containsAll(b.getEnclosingTopics())) continue;
                ranges.add((ITopicRange)b);
            }
        }
        return ranges;
    }

    public static ISummaryPart findAttachedSummary(IBranchPart branch, IBranchPart child) {
        ITopicPart childNode = child.getTopicPart();
        for (ISummaryPart summary : branch.getSummaries()) {
            if (summary.getNode() != childNode) continue;
            return summary;
        }
        return null;
    }

    public static String[] sortLabels(Collection<String> labels) {
        Object[] array = labels.toArray(new String[labels.size()]);
        Arrays.sort(array);
        return array;
    }

    public static String getLabelText(Collection<String> labels) {
        String s = Arrays.toString(MindMapUtils.sortLabels(labels));
        return s.substring(1, s.length() - 1);
    }

    public static Collection<String> getLabels(String text) {
        String[] sp = text.split(",");
        ArrayList<String> list = new ArrayList<String>(sp.length);
        String[] stringArray = sp;
        int n = sp.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!"".equals(s = s.trim()) && !list.contains(s)) {
                list.add(s);
            }
            ++n2;
        }
        return list;
    }

    public static String trimFileName(String name) {
        return name.replaceAll("\\r\\n|\\n|\\r|\\\\|/|\\||:|\"|>|<|\\*|\\?", " ");
    }

    public static String trimSingleLine(String name) {
        return name.replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public static ICacheManager getCacheManager(IPart p) {
        return (ICacheManager)p.getAdapter(ICacheManager.class);
    }

    public static Object getCache(IPart p, String key) {
        ICacheManager cacheManager = MindMapUtils.getCacheManager(p);
        if (cacheManager != null) {
            return cacheManager.getCache(key);
        }
        return null;
    }

    public static Object flushCache(IPart p, String key) {
        ICacheManager cacheManager = MindMapUtils.getCacheManager(p);
        if (cacheManager == null) {
            return null;
        }
        Object cache = cacheManager.getCache(key);
        cacheManager.flush(key);
        return cache;
    }

    public static Object setCache(IPart p, String key, Object value) {
        ICacheManager cacheManager = MindMapUtils.getCacheManager(p);
        if (cacheManager == null) {
            return null;
        }
        Object oldCache = cacheManager.getCache(key);
        cacheManager.setCache(key, value);
        return oldCache;
    }

    public static String getNumberText(ITopic topic, String defaultFormat) {
        if (!"attached".equals(topic.getType())) {
            return null;
        }
        ITopic parent = topic.getParent();
        if (parent == null) {
            return null;
        }
        int index = topic.getIndex();
        String format = parent.getNumbering().getComputedFormat();
        if ("org.xmind.numbering.none".equals(format) && defaultFormat != null && !"org.xmind.numbering.none".equals(defaultFormat)) {
            format = defaultFormat;
        }
        if (format == null) {
            if (defaultFormat == null) {
                return null;
            }
            format = defaultFormat;
        }
        return MindMapUI.getNumberFormatManager().getNumberText(format, index + 1);
    }

    public static String getNumberSeparator(ITopic topic, String defaultSeparator) {
        if (!"attached".equals(topic.getType())) {
            return null;
        }
        ITopic parent = topic.getParent();
        if (parent == null) {
            return null;
        }
        String separator = parent.getNumbering().getComputedSeparator();
        if ("org.xmind.numbering.separator.dot".equals(separator) && defaultSeparator != null && !"org.xmind.numbering.separator.dot".equals(defaultSeparator)) {
            separator = defaultSeparator;
        }
        if (separator == null) {
            if (defaultSeparator == null) {
                return null;
            }
            separator = defaultSeparator;
        }
        return MindMapUI.getNumberSeparatorManager().getSeparatorText(separator);
    }

    public static String getNumberingText(ITopic topic, String defaultFormat, String defaultSeparator) {
        String number = MindMapUtils.getNumberText(topic, defaultFormat);
        if (number == null || "".equals(number)) {
            return null;
        }
        if (topic.getNumbering().getNumberFormat() == null && topic.getNumbering().getDepth() == null && !topic.getNumbering().isInherited(0)) {
            return null;
        }
        ITopic parent = topic.getParent();
        INumbering numbering = parent.getNumbering();
        if (parent != null && numbering.prependsParentNumbers()) {
            String parentNumber;
            if (defaultFormat != null && numbering.getNumberFormat() != null) {
                defaultFormat = null;
            }
            if ((parentNumber = MindMapUtils.getNumberingText(parent, defaultFormat, defaultSeparator)) != null && parent.getNumbering().isInherited(1)) {
                String separator = MindMapUtils.getNumberSeparator(topic, defaultSeparator);
                if (separator == null) {
                    separator = NUMBER_SEPARATOR;
                }
                if (parentNumber.endsWith(separator)) {
                    return String.valueOf(parentNumber) + number;
                }
                return String.valueOf(parentNumber) + separator + number;
            }
        }
        return number;
    }

    public static String getFullNumberingText(ITopic topic, String defaultFormat, String defaultSeparator) {
        ITopic parent;
        String text = MindMapUtils.getNumberingText(topic, defaultFormat, defaultSeparator);
        if (text != null && (parent = topic.getParent()) != null) {
            String suffix;
            INumbering parentNumbering = parent.getNumbering();
            String prefix = parentNumbering.getPrefix();
            if (prefix != null) {
                text = String.valueOf(prefix) + " " + text;
            }
            if ((suffix = parentNumbering.getSuffix()) != null) {
                text = String.valueOf(text) + " " + suffix;
            }
        }
        return text;
    }

    public static boolean isSubBranchesFreeable(IBranchPart branch) {
        IStructure structure;
        if (branch != null && (structure = branch.getBranchPolicy().getStructure(branch)) instanceof IFreeableBranchStructureExtension) {
            return ((IFreeableBranchStructureExtension)structure).isChildrenFreeable(branch);
        }
        return false;
    }

    public static boolean isBranchFreeable(IBranchPart branch) {
        return branch != null && branch.getTopic().getPosition() != null;
    }

    public static boolean isBranchFree(IBranchPart branch) {
        if (branch == null) {
            return false;
        }
        IBranchPart parent = branch.getParentBranch();
        if (parent == null) {
            return false;
        }
        return MindMapUtils.isBranchFreeable(branch) && MindMapUtils.isSubBranchesFreeable(parent);
    }

    public static ISummary findSummaryBySummaryTopic(ITopic topic) {
        if (topic == null) {
            return null;
        }
        return MindMapUtils.findSummaryBySummaryTopic(topic, topic.getParent());
    }

    public static ISummary findSummaryBySummaryTopic(ITopic topic, ITopic parent) {
        if (topic == null || parent == null) {
            return null;
        }
        return MindMapUtils.findSummaryBySummaryTopic(topic, parent, parent.getSummaries());
    }

    public static ISummary findSummaryBySummaryTopic(ITopic topic, ITopic parent, Collection<? extends ITopicRange> ranges) {
        if (topic == null || parent == null || ranges.isEmpty()) {
            return null;
        }
        String id = topic.getId();
        for (ITopicRange iTopicRange : ranges) {
            ISummary s;
            if (!(iTopicRange instanceof ISummary) || !id.equals((s = (ISummary)iTopicRange).getTopicId())) continue;
            return s;
        }
        return null;
    }

    public static List<IBoundary> getSortedBoundaries(ITopic topic) {
        ArrayList<IBoundary> list = new ArrayList<IBoundary>(topic.getBoundaries());
        Collections.sort(list, new Comparator<IBoundary>(){
            Map<IBoundary, List<ITopic>> cache = new HashMap<IBoundary, List<ITopic>>();

            @Override
            public int compare(IBoundary o1, IBoundary o2) {
                List<ITopic> ts2;
                if (o1.isMasterBoundary()) {
                    return 1;
                }
                if (o2.isMasterBoundary()) {
                    return -1;
                }
                List<ITopic> ts1 = this.cache.get(o1);
                if (ts1 == null) {
                    ts1 = new ArrayList<ITopic>(o1.getEnclosingTopics());
                    this.cache.put(o1, ts1);
                }
                if ((ts2 = this.cache.get(o2)) == null) {
                    ts2 = new ArrayList<ITopic>(o2.getEnclosingTopics());
                    this.cache.put(o2, ts2);
                }
                int ret = ts1.containsAll(ts2) ? ts1.size() - ts2.size() + 1 : (ts2.containsAll(ts1) ? ts1.size() - ts2.size() - 1 : (ts1.isEmpty() ? -ts2.size() - 1 : (ts2.isEmpty() ? ts1.size() + 1 : ts1.get(0).getIndex() - ts2.get(0).getIndex())));
                return -ret;
            }
        });
        return list;
    }

    public static int getLevel(ITopic t, ITopic rootTopic) {
        if (t.equals(rootTopic) || rootTopic == null && t.isRoot()) {
            return 0;
        }
        ITopic parent = t.getParent();
        if (parent == null) {
            return -1;
        }
        int parentLevel = MindMapUtils.getLevel(parent, rootTopic);
        if (parentLevel < 0) {
            return parentLevel;
        }
        return parentLevel + 1;
    }

    public static IWorkbook findWorkbook(Object source) {
        Object adapter;
        if (source instanceof IWorkbook) {
            return (IWorkbook)source;
        }
        if (source instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)source).getOwnedWorkbook();
        }
        if (source instanceof org.xmind.core.IAdaptable) {
            adapter = ((org.xmind.core.IAdaptable)source).getAdapter(IWorkbook.class);
            if (adapter instanceof IWorkbook) {
                return (IWorkbook)adapter;
            }
            adapter = ((org.xmind.core.IAdaptable)source).getAdapter(IWorkbookComponent.class);
            if (adapter instanceof IWorkbookComponent) {
                return ((IWorkbookComponent)adapter).getOwnedWorkbook();
            }
        }
        if (source instanceof IAdaptable) {
            adapter = ((IAdaptable)source).getAdapter(IWorkbook.class);
            if (adapter instanceof IWorkbook) {
                return (IWorkbook)adapter;
            }
            adapter = ((IAdaptable)source).getAdapter(IWorkbookComponent.class);
            if (adapter instanceof IWorkbookComponent) {
                return ((IWorkbookComponent)adapter).getOwnedWorkbook();
            }
        }
        return null;
    }

    public static ISheet findSheet(Object source) {
        Object adapter;
        if (source instanceof ISheet) {
            return (ISheet)source;
        }
        if (source instanceof IWorkbookComponent) {
            return ((ISheetComponent)source).getOwnedSheet();
        }
        if (source instanceof org.xmind.core.IAdaptable) {
            adapter = ((org.xmind.core.IAdaptable)source).getAdapter(ISheet.class);
            if (adapter instanceof ISheet) {
                return (ISheet)adapter;
            }
            adapter = ((org.xmind.core.IAdaptable)source).getAdapter(ISheetComponent.class);
            if (adapter instanceof ISheetComponent) {
                return ((ISheetComponent)adapter).getOwnedSheet();
            }
        }
        if (source instanceof IAdaptable) {
            adapter = ((IAdaptable)source).getAdapter(ISheet.class);
            if (adapter instanceof ISheet) {
                return (ISheet)adapter;
            }
            adapter = ((IAdaptable)source).getAdapter(ISheetComponent.class);
            if (adapter instanceof ISheetComponent) {
                return ((ISheetComponent)adapter).getOwnedSheet();
            }
        }
        return null;
    }

    public static List<ITopicPart> getTopicParts(List<IPart> parts) {
        ArrayList<ITopicPart> topics = new ArrayList<ITopicPart>(parts.size());
        for (IPart p : parts) {
            if (p instanceof ITopicPart) {
                topics.add((ITopicPart)p);
                continue;
            }
            if (p instanceof IIconTipPart) {
                topics.add(((IIconTipPart)p).getTopicPart());
                continue;
            }
            if (!(p instanceof IInfoItemPart)) continue;
            topics.add(((IInfoItemPart)p).getTopicPart());
        }
        topics.trimToSize();
        return topics;
    }

    public static List<ITopic> getAllTopics(ISheet sheet, boolean includeFloatingTopic, boolean includeSummary) {
        ArrayList<ITopic> topics = new ArrayList<ITopic>();
        if (sheet != null && sheet.getRootTopic() != null) {
            MindMapUtils.fillTopics(topics, sheet.getRootTopic(), includeFloatingTopic, includeSummary);
        }
        return topics;
    }

    private static void fillTopics(List<ITopic> topics, ITopic topic, boolean includeFloatingTopic, boolean includeSummary) {
        if (topics == null || topic == null) {
            return;
        }
        topics.add(topic);
        List children = topic.getAllChildren();
        if (!includeFloatingTopic && !includeSummary) {
            children.removeAll(topic.getChildren("detached"));
            children.removeAll(topic.getChildren("summary"));
        } else if (includeFloatingTopic && !includeSummary) {
            children.removeAll(topic.getChildren("summary"));
        } else if (!includeFloatingTopic && includeSummary) {
            children.removeAll(topic.getChildren("detached"));
        }
        if (children == null || children.size() == 0) {
            return;
        }
        for (ITopic child : children) {
            MindMapUtils.fillTopics(topics, child, includeFloatingTopic, includeSummary);
        }
    }

    public static List<ITopic> getAllFloatingTopics(ISheet sheet) {
        if (sheet == null) {
            return new ArrayList<ITopic>();
        }
        ITopic rootTopic = sheet.getRootTopic();
        if (rootTopic == null) {
            return new ArrayList<ITopic>();
        }
        ArrayList<ITopic> topics = new ArrayList<ITopic>();
        MindMapUtils.fillFloatingTopics(topics, rootTopic);
        return topics;
    }

    private static void fillFloatingTopics(List<ITopic> topics, ITopic topic) {
        if (topics == null || topic == null) {
            return;
        }
        topics.add(topic);
        List children = null;
        children = topic.isRoot() ? topic.getChildren("detached") : topic.getAllChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        for (ITopic child : children) {
            MindMapUtils.fillFloatingTopics(topics, child);
        }
    }

    public static ICommandStack getCommandStack(IWorkbook workbook) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IEditorReference[] editorRefs;
            IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editor = editorRef.getEditor(false);
                if (editor instanceof MindMapEditor && ((MindMapEditor)editor).getWorkbook() == workbook) {
                    return ((MindMapEditor)editor).getCommandStack();
                }
                ++n2;
            }
        }
        return ICommandStack.NULL;
    }

    @Deprecated
    public static ITopicPart getTopicPart(ITopic topic) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        IGraphicalViewer viewer = (IGraphicalViewer)activeEditor.getAdapter(IGraphicalViewer.class);
        if (viewer == null) {
            return null;
        }
        IPart part = viewer.findPart((Object)topic);
        if (part instanceof ITopicPart) {
            return (ITopicPart)part;
        }
        return (ITopicPart)part.getAdapter(ITopicPart.class);
    }

    public static String getFamily(IStyled styleOwner, IMindMap mindmap) {
        if (styleOwner instanceof ISheet) {
            return "map";
        }
        if (styleOwner instanceof IBoundary) {
            return "boundary";
        }
        if (styleOwner instanceof ISummary) {
            return "summary";
        }
        if (styleOwner instanceof IRelationship) {
            return "relationship";
        }
        if (styleOwner instanceof ITopic) {
            ITopic topic = (ITopic)styleOwner;
            if (topic.equals(mindmap.getCentralTopic())) {
                return "centralTopic";
            }
            if (mindmap.getCentralTopic().equals(topic.getParent())) {
                if (topic.isAttached()) {
                    return "mainTopic";
                }
                if ("detached".equals(topic.getType())) {
                    return "floatingTopic";
                }
                if ("summary".equals(topic.getType())) {
                    return "summaryTopic";
                }
            }
            if ("callout".equals(topic.getType())) {
                return "calloutTopic";
            }
            return "subTopic";
        }
        return null;
    }

    public static void reveal(IGraphicalEditor sourceEditor, ITopic topic) {
        ISelectionProvider selectionProvider;
        if (sourceEditor == null) {
            return;
        }
        sourceEditor.getSite().getPage().activate((IWorkbenchPart)sourceEditor);
        if (topic != null && (selectionProvider = sourceEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)topic));
        }
    }

    public static ITopicPart findTopicPart(IViewer viewer, ITopic topic) {
        if (viewer == null) {
            return null;
        }
        IPart part = viewer.findPart((Object)topic);
        if (part == null) {
            return null;
        }
        ITopicPart topicPart = part instanceof ITopicPart ? (ITopicPart)part : (ITopicPart)part.getAdapter(ITopicPart.class);
        return topicPart;
    }
}

