/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Image;
import org.xmind.core.internal.dom.InternalHyperlinkUtils;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageImpl
extends Image
implements ICoreEventSource {
    private Element topicElement;
    private TopicImpl ownedTopic;

    public ImageImpl(Element topicElement, TopicImpl ownedTopic) {
        this.topicElement = topicElement;
        this.ownedTopic = ownedTopic;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ImageImpl)) {
            return false;
        }
        ImageImpl that = (ImageImpl)obj;
        return this.topicElement == that.topicElement;
    }

    public int hashCode() {
        return this.topicElement.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.getImageElement());
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getImageElement());
        }
        return super.getAdapter(adapter);
    }

    private Element getImageElement() {
        return DOMUtils.getFirstChildElementByTag(this.topicElement, "xhtml:img");
    }

    @Override
    public String getAlignment() {
        Element img = this.getImageElement();
        return img == null ? null : DOMUtils.getAttribute(img, "align");
    }

    @Override
    public int getHeight() {
        Element img = this.getImageElement();
        if (img == null) {
            return -1;
        }
        return NumberUtils.safeParseInt(DOMUtils.getAttribute(img, "svg:height"), -1);
    }

    private Integer getHeightInt() {
        int h = this.getHeight();
        return h < 0 ? null : Integer.valueOf(h);
    }

    private Integer getWidthInt() {
        int w = this.getWidth();
        return w < 0 ? null : Integer.valueOf(w);
    }

    @Override
    public ITopic getParent() {
        return this.ownedTopic;
    }

    @Override
    public String getSource() {
        Element img = this.getImageElement();
        return img == null ? null : DOMUtils.getAttribute(img, "xhtml:src");
    }

    @Override
    public int getWidth() {
        Element img = this.getImageElement();
        if (img == null) {
            return -1;
        }
        return NumberUtils.safeParseInt(DOMUtils.getAttribute(img, "svg:width"), -1);
    }

    private Element ensureImageElement() {
        return DOMUtils.ensureChildElement(this.topicElement, "xhtml:img");
    }

    @Override
    public void setAlignment(String alignment) {
        String oldValue = this.getAlignment();
        Element img = this.ensureImageElement();
        DOMUtils.setAttribute(img, "align", alignment);
        this.checkImageElement();
        String newValue = this.getAlignment();
        this.fireValueChange("imageAlignment", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setHeight(int height) {
        Integer oldValue = this.getHeightInt();
        Element img = this.ensureImageElement();
        String h = height < 0 ? null : Integer.toString(height);
        DOMUtils.setAttribute(img, "svg:height", h);
        this.checkImageElement();
        Integer newValue = this.getHeightInt();
        this.fireValueChange("imageHeight", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setSize(int width, int height) {
        Integer oldWidth = this.getWidthInt();
        Integer oldHeight = this.getHeightInt();
        Element img = this.ensureImageElement();
        String h = height < 0 ? null : Integer.toString(height);
        String w = width < 0 ? null : Integer.toString(width);
        DOMUtils.setAttribute(img, "svg:height", h);
        DOMUtils.setAttribute(img, "svg:width", w);
        this.checkImageElement();
        Integer newWidth = this.getWidthInt();
        Integer newHeight = this.getHeightInt();
        this.fireValueChange("imageWidth", oldWidth, newWidth);
        this.fireValueChange("imageHeight", oldHeight, newHeight);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setSource(String source) {
        String oldValue = this.getSource();
        Element img = this.ensureImageElement();
        IWorkbook workbook = this.ownedTopic.getPath().getWorkbook();
        this.deactivateHyperlink(workbook);
        DOMUtils.setAttribute(img, "xhtml:src", source);
        this.activateHyperlink(workbook);
        this.checkImageElement();
        String newValue = this.getSource();
        this.fireValueChange("imageSource", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    @Override
    public void setWidth(int width) {
        Integer oldValue = this.getWidthInt();
        Element img = this.ensureImageElement();
        String w = width < 0 ? null : Integer.toString(width);
        DOMUtils.setAttribute(img, "svg:width", w);
        this.checkImageElement();
        Integer newValue = this.getWidthInt();
        this.fireValueChange("imageWidth", oldValue, newValue);
        this.ownedTopic.updateModificationInfo();
    }

    private void checkImageElement() {
        Element img = this.getImageElement();
        if (!img.hasChildNodes() && !img.hasAttributes()) {
            this.topicElement.removeChild(img);
        }
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.ownedTopic.getOwnedSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedTopic.getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return this.ownedTopic.isOrphan() || this.getImageElement() == null;
    }

    private void fireValueChange(String eventType, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, eventType, oldValue, newValue);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedTopic.getCoreEventSupport();
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    protected void activateHyperlink(IWorkbook workbook) {
        InternalHyperlinkUtils.activateHyperlink(workbook, this.getSource(), this);
    }

    protected void deactivateHyperlink(IWorkbook workbook) {
        InternalHyperlinkUtils.deactivateHyperlink(workbook, this.getSource(), this);
    }
}

