/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.internal.WorkbookExtensionElement;
import org.xmind.core.internal.dom.WorkbookExtensionImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookExtensionElementImpl
extends WorkbookExtensionElement {
    private Element implementation;
    private WorkbookImpl workbook;
    private WorkbookExtensionImpl extension;

    public WorkbookExtensionElementImpl(Element implementation, WorkbookImpl workbook, WorkbookExtensionImpl extension) {
        this.implementation = implementation;
        this.workbook = workbook;
        this.extension = extension;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.workbook;
    }

    @Override
    public IWorkbookExtension getExtension() {
        return this.extension;
    }

    @Override
    public String getName() {
        return this.implementation.getTagName();
    }

    @Override
    public List<IWorkbookExtensionElement> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<IWorkbookExtensionElement> getChildren(String elementName) {
        return DOMUtils.getChildList(this.implementation, elementName, this.extension);
    }

    @Override
    public IWorkbookExtensionElement getParent() {
        Node p = this.implementation.getParentNode();
        if (p == null || !(p instanceof Element)) {
            return null;
        }
        return this.extension.getElement((Element)p);
    }

    @Override
    public IWorkbookExtensionElement createChild(String elementName) {
        Element childImpl = DOMUtils.createElement(this.implementation, elementName);
        WorkbookExtensionElementImpl child = new WorkbookExtensionElementImpl(childImpl, this.workbook, this.extension);
        this.registerChild(child);
        this.workbook.updateModificationInfo();
        return child;
    }

    @Override
    public IWorkbookExtensionElement getFirstChild(String elementName) {
        Element childImpl = DOMUtils.getFirstChildElementByTag(this.implementation, elementName);
        return childImpl == null ? null : this.extension.getElement(childImpl);
    }

    @Override
    public void addChild(IWorkbookExtensionElement child, int index) {
        WorkbookExtensionElementImpl c = (WorkbookExtensionElementImpl)child;
        if (c.getExtension() != this.getExtension() || c.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            return;
        }
        IWorkbookExtensionElement oldParent = c.getParent();
        if (oldParent != null) {
            oldParent.deleteChild(child);
        }
        Element childImpl = c.getImplementation();
        Element[] es = DOMUtils.getChildElements(this.implementation);
        if (index >= 0 && index < es.length) {
            this.implementation.insertBefore(childImpl, es[index]);
        } else {
            this.implementation.appendChild(childImpl);
        }
        this.registerChild(c);
        this.workbook.updateModificationInfo();
    }

    @Override
    public void deleteChild(IWorkbookExtensionElement child) {
        WorkbookExtensionElementImpl c = (WorkbookExtensionElementImpl)child;
        Element childImpl = c.getImplementation();
        if (childImpl.getParentNode() == this.implementation) {
            this.unregisterChild(c);
            this.implementation.removeChild(childImpl);
            this.workbook.updateModificationInfo();
        }
    }

    @Override
    public void deleteChildren() {
        this.deleteChildren(null);
    }

    @Override
    public void deleteChildren(String elementName) {
        Element[] children = elementName == null ? DOMUtils.getChildElements(this.implementation) : DOMUtils.getChildElementsByTag(this.implementation, elementName);
        int i = 0;
        while (i < children.length) {
            this.implementation.removeChild(children[i]);
            ++i;
        }
        if (children.length > 0) {
            this.workbook.updateModificationInfo();
        }
    }

    @Override
    public Set<String> getAttributeKeys() {
        HashSet<String> keys = new HashSet<String>();
        NamedNodeMap atts = this.implementation.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node att = atts.item(i);
            String key = att.getNodeName();
            if (key != null && !"".equals(key)) {
                keys.add(key);
            }
            ++i;
        }
        return keys;
    }

    @Override
    public String getAttribute(String attrName) {
        return DOMUtils.getAttribute(this.implementation, attrName);
    }

    @Override
    public void setAttribute(String attrName, String attrValue) {
        DOMUtils.setAttribute(this.implementation, attrName, attrValue);
        this.workbook.updateModificationInfo();
    }

    @Override
    public String getTextContent() {
        Node c = this.implementation.getFirstChild();
        if (c != null && c.getNodeType() == 3) {
            return c.getTextContent();
        }
        return null;
    }

    @Override
    public void setTextContent(String text) {
        Node c = this.implementation.getFirstChild();
        if (text == null) {
            if (c != null) {
                this.implementation.removeChild(c);
                this.workbook.updateModificationInfo();
            }
        } else {
            if (c != null && c.getNodeType() == 3) {
                c.setTextContent(text);
            } else {
                Text t = this.implementation.getOwnerDocument().createTextNode(text);
                this.implementation.insertBefore(t, c);
            }
            this.workbook.updateModificationInfo();
        }
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.setAttribute("resource-path", resourcePath);
    }

    @Override
    public String getResourcePath() {
        return this.getAttribute("resource-path");
    }

    @Override
    public void setObjectId(String objectId) {
        this.setAttribute("object-id", objectId);
    }

    @Override
    public String getObjectId() {
        return this.getAttribute("object-id");
    }

    private void registerChild(WorkbookExtensionElementImpl child) {
        this.extension.registerElement(child);
    }

    private void unregisterChild(WorkbookExtensionElementImpl child) {
        this.extension.unregisterElement(child);
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookExtensionElementImpl)) {
            return false;
        }
        WorkbookExtensionElementImpl that = (WorkbookExtensionElementImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "{element:}" + this.getName() + "}";
    }
}

