/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.ResourceViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceExportWizardSelectionPage
extends AbstractExportPage {
    private static final String PAGE_SELECTION_NAME = "org.xmind.ui.xmindresource.ResourceExportWizardSelectionPage";
    private PageBook pageStack;
    private Label defaultPage;
    private TreeViewer viewer;
    private ResourceViewer themePageViewer;
    private ResourceViewer templatePageViewer;
    private ResourceViewer clipartPageViewer;
    private MarkerPageViewer markerPageViewer;
    private Button allSelectCheck;
    private ResourceManager resources;

    protected ResourceExportWizardSelectionPage() {
        super(PAGE_SELECTION_NAME, Messages.ResourceExportWizardSelectionPage_title, null);
        this.setDescription(Messages.ResourceExportWizardSelectionPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(composite.getDisplay().getSystemColor(1));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        this.createLeftControl(composite);
        this.createRightControl(composite);
        this.createSelectAllCheck(composite);
    }

    protected boolean isPageCompletable() {
        return true;
    }

    private void createSelectAllCheck(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.allSelectCheck = new Button(parent, 32);
        this.allSelectCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.allSelectCheck.setText(Messages.ResourceExportWizardSelectionPage_SelectAll);
        this.allSelectCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ResourceExportWizardSelectionPage.this.allSelectCheck.getSelection();
                ISelection selection = ResourceExportWizardSelectionPage.this.viewer.getSelection();
                if (selection instanceof StructuredSelection) {
                    Object resourceType = ((StructuredSelection)selection).getFirstElement();
                    if (ResourceExportWizardSelectionPage.this.pageStack != null && !ResourceExportWizardSelectionPage.this.pageStack.isDisposed()) {
                        if (XMindResourcePlugin.RESOURCE_TYPE_THEME.equals(resourceType) && ResourceExportWizardSelectionPage.this.themePageViewer != null) {
                            ResourceExportWizardSelectionPage.this.themePageViewer.selectAllItems(selected);
                        } else if (XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE.equals(resourceType) && ResourceExportWizardSelectionPage.this.templatePageViewer != null) {
                            ResourceExportWizardSelectionPage.this.templatePageViewer.selectAllItems(selected);
                        } else if (XMindResourcePlugin.RESOURCE_TYPE_CLIPART.equals(resourceType) && ResourceExportWizardSelectionPage.this.clipartPageViewer != null) {
                            ResourceExportWizardSelectionPage.this.clipartPageViewer.selectAllItems(selected);
                        } else if (XMindResourcePlugin.RESOURCE_TYPE_MARKER.equals(resourceType) && ResourceExportWizardSelectionPage.this.markerPageViewer != null) {
                            ResourceExportWizardSelectionPage.this.markerPageViewer.selectAllItems(selected);
                        }
                    }
                }
                if (ResourceExportWizardSelectionPage.this.viewer != null) {
                    ResourceExportWizardSelectionPage.this.refreshTreeViewer(selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRightControl(Composite contentComposite) {
        Composite rightComposite = new Composite(contentComposite, 2048);
        rightComposite.setBackground(contentComposite.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        rightComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 520;
        layoutData.heightHint = 300;
        rightComposite.setLayoutData((Object)layoutData);
        this.pageStack = new PageBook(rightComposite, 0);
        this.pageStack.setBackground(rightComposite.getBackground());
        this.pageStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPage = this.createDefaultPage(this.pageStack);
        this.defaultPage.setText(Messages.ResourceExportWizardSelectionPage_NoTheme_title);
        this.themePageViewer = this.createThemePage((Composite)this.pageStack);
        if (this.themePageViewer.getContentProvider().getElements(this.themePageViewer.getInput()).length == 0) {
            this.pageStack.showPage((Control)this.defaultPage);
        } else {
            this.showPage(this.themePageViewer);
        }
    }

    private Label createDefaultPage(PageBook parent) {
        Label defaultPage = new Label((Composite)parent, 320);
        defaultPage.setBackground(parent.getBackground());
        return defaultPage;
    }

    private ResourceViewer createThemePage(Composite parent) {
        ResourceViewer viewer = new ResourceViewer(parent);
        viewer.setInput(MindMapUI.getResourceManager().getUserThemeSheet().getStyles("master-styles"));
        return viewer;
    }

    private ResourceViewer createTemplatePage(Composite parent) {
        ResourceViewer viewer = new ResourceViewer(parent);
        viewer.setInput(MindMapUI.getResourceManager().getUserTemplates());
        return viewer;
    }

    private ResourceViewer createClipArtPage(Composite parent) {
        ResourceViewer viewer = new ResourceViewer(parent);
        viewer.setInput(GalleryCore.getInstance().getUserGalleryGroups().get(0));
        return viewer;
    }

    private MarkerPageViewer createMarkerPage(Composite parent) {
        MarkerPageViewer viewer = new MarkerPageViewer(parent, this.resources);
        viewer.setInput(MindMapUI.getResourceManager().getUserMarkerSheet().getMarkerGroups());
        return viewer;
    }

    private void createLeftControl(Composite contentComposite) {
        Composite leftComposite = new Composite(contentComposite, 0);
        leftComposite.setBackground(contentComposite.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        leftComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(0x1000000, 4, false, true);
        layoutData.minimumWidth = 100;
        leftComposite.setLayoutData((Object)layoutData);
        this.viewer = new TreeViewer(leftComposite, 67176448);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.viewer.setInput((Object)new String[]{XMindResourcePlugin.RESOURCE_TYPE_THEME, XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE, XMindResourcePlugin.RESOURCE_TYPE_CLIPART, XMindResourcePlugin.RESOURCE_TYPE_MARKER});
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)XMindResourcePlugin.RESOURCE_TYPE_THEME));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceExportWizardSelectionPage.this.allSelectCheck.setSelection(false);
                ResourceExportWizardSelectionPage.this.refreshTreeViewer(event.getSelection());
            }
        });
    }

    private void refreshTreeViewer(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object resourceType = ((StructuredSelection)selection).getFirstElement();
            if (this.pageStack != null && !this.pageStack.isDisposed()) {
                if (XMindResourcePlugin.RESOURCE_TYPE_THEME.equals(resourceType)) {
                    if (this.themePageViewer == null) {
                        this.themePageViewer = this.createThemePage((Composite)this.pageStack);
                    }
                    if (this.themePageViewer.getContentProvider().getElements(this.themePageViewer.getInput()).length == 0) {
                        this.defaultPage.setText(Messages.ResourceExportWizardSelectionPage_NoTheme_title);
                        this.pageStack.showPage((Control)this.defaultPage);
                    } else {
                        this.showPage(this.themePageViewer);
                    }
                } else if (XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE.equals(resourceType)) {
                    if (this.templatePageViewer == null) {
                        this.templatePageViewer = this.createTemplatePage((Composite)this.pageStack);
                    }
                    if (this.templatePageViewer.getContentProvider().getElements(this.templatePageViewer.getInput()).length == 0) {
                        this.defaultPage.setText(Messages.ResourceExportWizardSelectionPage_NoTemplate_title);
                        this.pageStack.showPage((Control)this.defaultPage);
                    } else {
                        this.showPage(this.templatePageViewer);
                    }
                } else if (XMindResourcePlugin.RESOURCE_TYPE_CLIPART.equals(resourceType)) {
                    if (this.clipartPageViewer == null) {
                        this.clipartPageViewer = this.createClipArtPage((Composite)this.pageStack);
                    }
                    if (this.clipartPageViewer.getContentProvider().getElements(this.clipartPageViewer.getInput()).length == 0) {
                        this.defaultPage.setText(Messages.ResourceExportWizardSelectionPage_NoClipart_title);
                        this.pageStack.showPage((Control)this.defaultPage);
                    } else {
                        this.showPage(this.clipartPageViewer);
                    }
                } else if (XMindResourcePlugin.RESOURCE_TYPE_MARKER.equals(resourceType)) {
                    if (this.markerPageViewer == null) {
                        this.markerPageViewer = this.createMarkerPage((Composite)this.pageStack);
                    }
                    if (this.markerPageViewer.getInput().isEmpty()) {
                        this.defaultPage.setText(Messages.ResourceExportWizardSelectionPage_NoMarker_title);
                        this.pageStack.showPage((Control)this.defaultPage);
                    } else {
                        this.pageStack.showPage(this.markerPageViewer.getControl());
                    }
                }
            }
        }
    }

    private void showPage(ResourceViewer pageViewer) {
        Object input = pageViewer.getInput();
        Object[] inputElements = pageViewer.getContentProvider().getElements(input);
        if (inputElements == null || inputElements.length == 0) {
            this.pageStack.showPage((Control)this.defaultPage);
        } else {
            this.pageStack.showPage(pageViewer.getControl());
        }
    }

    protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
        filterNames.clear();
        String ext = "*.xrb";
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)Messages.ResourceImportExportWizardPage_FilterName, (Object)ext));
        filterExtensions.clear();
        filterExtensions.add(ext);
        super.setDialogFilters(dialog, filterNames, filterExtensions);
    }

    public List<Object> getElementsToExport() {
        ArrayList<Object> elementsToExport = new ArrayList<Object>();
        if (this.themePageViewer != null) {
            elementsToExport.addAll(this.themePageViewer.getSelectedItems());
        }
        if (this.templatePageViewer != null) {
            elementsToExport.addAll(this.templatePageViewer.getSelectedItems());
        }
        if (this.clipartPageViewer != null) {
            elementsToExport.addAll(this.clipartPageViewer.getSelectedItems());
        }
        if (this.markerPageViewer != null) {
            elementsToExport.addAll(this.markerPageViewer.getCheckedElements());
        }
        return elementsToExport;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkerPageViewer {
        private Composite markerPageControl;
        private List<IMarkerGroup> input = new ArrayList<IMarkerGroup>();
        private Map<Button, IMarkerGroup> checkToMarkerGroup = new HashMap<Button, IMarkerGroup>();
        private ResourceManager resources;

        public MarkerPageViewer(Composite parent, ResourceManager resources) {
            this.resources = resources;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            this.markerPageControl = composite;
        }

        public void setInput(List<IMarkerGroup> groups) {
            this.input = groups;
            if (groups != null) {
                for (IMarkerGroup markerGroup : groups) {
                    this.createGroup(this.markerPageControl, markerGroup);
                }
            }
        }

        public List<IMarkerGroup> getInput() {
            return this.input;
        }

        public Control getControl() {
            return this.markerPageControl;
        }

        private void createGroup(Composite parent, IMarkerGroup group) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button groupControl = new Button(composite, 32);
            this.checkToMarkerGroup.put(groupControl, group);
            groupControl.setText(group.getName());
            List markers = group.getMarkers();
            Composite markersContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(markers.size(), true);
            layout.marginLeft = 10;
            markersContainer.setLayout((Layout)layout);
            for (IMarker marker : markers) {
                Label markerLabel = new Label(markersContainer, 0x1000000);
                markerLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)24, (int)24)));
            }
        }

        public List<IMarkerGroup> getCheckedElements() {
            ArrayList<IMarkerGroup> selectedGroups = new ArrayList<IMarkerGroup>();
            Set<Button> keys = this.checkToMarkerGroup.keySet();
            for (Button checkedItem : keys) {
                if (!checkedItem.getSelection()) continue;
                selectedGroups.add(this.checkToMarkerGroup.get(checkedItem));
            }
            return selectedGroups;
        }

        public void selectAllItems(boolean select) {
            if (!this.checkToMarkerGroup.isEmpty()) {
                Set<Button> keys = this.checkToMarkerGroup.keySet();
                for (Button key : keys) {
                    key.setSelection(select);
                }
            }
        }
    }
}

