/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.ConfigurableRefreshOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.ResourcePrincipalsV3AuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.DefaultRptPathProvider;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.FileBasedKeySupplier;
import com.oracle.bmc.auth.internal.FileBasedResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.FixedContentKeySupplier;
import com.oracle.bmc.auth.internal.FixedContentResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.KeyPairAuthenticationDetailProvider;
import com.oracle.bmc.auth.internal.ResourcePrincipalV2FederationClient;
import com.oracle.bmc.auth.internal.ResourcePrincipalsFederationClient;
import com.oracle.bmc.auth.internal.RptPathProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.NameUtils;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class ResourcePrincipalAuthenticationDetailsProvider
extends AbstractRequestingAuthenticationDetailsProvider
implements RegionProvider,
RefreshableOnNotAuthenticatedProvider<String>,
ConfigurableRefreshOnNotAuthenticatedProvider<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePrincipalAuthenticationDetailsProvider.class);
    static final String OCI_RESOURCE_PRINCIPAL_VERSION = "OCI_RESOURCE_PRINCIPAL_VERSION";
    static final String RP_VERSION_2_2 = "2.2";
    static final String OCI_RESOURCE_PRINCIPAL_RPST = "OCI_RESOURCE_PRINCIPAL_RPST";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT = "OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT";
    private static final String OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT = "OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT";
    private static final String OCI_RESOURCE_PRINCIPAL_RPT_PATH = "OCI_RESOURCE_PRINCIPAL_RPT_PATH";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE";
    static final String OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME = "OCI_RESOURCE_PRINCIPAL_REGION";
    private static final String OCI_RESOURCE_PRINCIPAL_RESOURCE_ID = "OCI_RESOURCE_PRINCIPAL_RESOURCE_ID";
    private static final String OCI_RESOURCE_PRINCIPAL_TENANCY_ID = "OCI_RESOURCE_PRINCIPAL_TENANCY_ID";
    private static final String OCI_RESOURCE_PRINCIPAL_SECURITY_CONTEXT = "OCI_RESOURCE_PRINCIPAL_SECURITY_CONTEXT";
    private static final String RP_VERSION_1_1 = "1.1";
    protected static final String RP_VERSION_2_1 = "2.1";
    protected static final String RP_VERSION_2_1_1 = "2.1.1";
    protected static final String RP_VERSION_2_1_2 = "2.1.2";
    protected static final String RP_VERSION_3_0 = "3.0";
    private static final String DEFAULT_OCI_RESOURCE_PRINCIPAL_RPT_PATH_FORV212 = "20180711/resourcePrincipalTokenV212";
    private static final String RP_DEBUG_INFORMATION_LOG = "\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.";
    protected final Region region;

    public ResourcePrincipalAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier);
        this.region = region;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static ResourcePrincipalAuthenticationDetailsProviderBuilder builder() {
        return new ResourcePrincipalAuthenticationDetailsProviderBuilder();
    }

    public String getStringClaim(String key) {
        return this.federationClient.getStringClaim(key);
    }

    @Override
    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public String refreshIfExpiringWithin(Duration time) {
        return this.refreshIfExpiringWithin(time, true);
    }

    @Override
    public String refreshIfExpiringWithin(Duration time, boolean refreshKeys) {
        if (this.federationClient instanceof ProvidesConfigurableRefresh) {
            return ((ProvidesConfigurableRefresh)((Object)this.federationClient)).refreshAndGetSecurityTokenIfExpiringWithin(time, refreshKeys);
        }
        return this.federationClient.refreshAndGetSecurityToken();
    }

    protected static Region getRegion(String ociResourcePrincipalRegion, String inputType) {
        if (ociResourcePrincipalRegion == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_REGION " + inputType + " missing." + RP_DEBUG_INFORMATION_LOG);
        }
        return Region.valueOf(NameUtils.canonicalizeForEnumTypes(ociResourcePrincipalRegion));
    }

    protected static FederationClient getFederationClientFromRpst(String ociResourcePrincipalRpst, String inputType, SessionKeySupplier sessionKeySupplier) {
        FederationClient federationClient;
        if (ociResourcePrincipalRpst == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_RPST " + inputType + " missing." + RP_DEBUG_INFORMATION_LOG);
        }
        String ociResourcePrincipalRpstPath = ociResourcePrincipalRpst;
        if (new File(ociResourcePrincipalRpstPath).exists()) {
            LOG.debug("Valid file for RPST. Creating instance of FileBasedResourcePrincipalFederationClient");
            federationClient = new FileBasedResourcePrincipalFederationClient(sessionKeySupplier, ociResourcePrincipalRpstPath);
        } else {
            LOG.debug("Loading RPST from content provided. Creating instance of FixedContentResourcePrincipalFederationClient");
            federationClient = new FixedContentResourcePrincipalFederationClient(ociResourcePrincipalRpst, sessionKeySupplier);
        }
        return federationClient;
    }

    protected static SessionKeySupplier getSessionKeySupplierFromPemAndPassphrase(String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String inputType) {
        SessionKeySupplier sessionKeySupplier;
        if (ociResourcePrincipalPrivateKey == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + inputType + " missing." + RP_DEBUG_INFORMATION_LOG);
        }
        String ociResourcePrincipalPrivateKeyPath = ociResourcePrincipalPrivateKey;
        if (new File(ociResourcePrincipalPrivateKeyPath).exists()) {
            if (ociResourcePrincipalPassphrase != null && !new File(ociResourcePrincipalPassphrase).exists()) {
                throw new IllegalArgumentException("Cannot mix path and constant settings for OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + ociResourcePrincipalPrivateKey + " and " + OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE + " " + ociResourcePrincipalPassphrase + RP_DEBUG_INFORMATION_LOG);
            }
            LOG.debug("Valid file for private key. Creating instance of FileBasedKeySupplier");
            sessionKeySupplier = new FileBasedKeySupplier(ociResourcePrincipalPrivateKeyPath, ociResourcePrincipalPassphrase);
        } else {
            char[] passPhraseChars = ociResourcePrincipalPassphrase != null ? ociResourcePrincipalPassphrase.toCharArray() : null;
            LOG.debug("Invalid file for private key, using the content provided. Creating instance of FixedContentKeySupplier");
            sessionKeySupplier = new FixedContentKeySupplier(ociResourcePrincipalPrivateKey, passPhraseChars);
        }
        return sessionKeySupplier;
    }

    public static class ResourcePrincipalAuthenticationDetailsProviderBuilder
    extends AbstractFederationClientAuthenticationDetailsProviderBuilder<ResourcePrincipalAuthenticationDetailsProviderBuilder, ResourcePrincipalAuthenticationDetailsProvider> {
        protected String resourcePrincipalTokenEndpoint;
        protected RptPathProvider resourcePrincipalTokenPathProvider;
        protected CircuitBreakerConfiguration circuitBreakerConfig;
        protected String securityContext;

        ResourcePrincipalAuthenticationDetailsProviderBuilder() {
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenPathProvider(RptPathProvider resourcePrincipalTokenPathProvider) {
            this.resourcePrincipalTokenPathProvider = resourcePrincipalTokenPathProvider;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenEndpoint(String resourcePrincipalTokenEndpoint) {
            this.resourcePrincipalTokenEndpoint = resourcePrincipalTokenEndpoint;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder circuitBreakerConfig(CircuitBreakerConfiguration circuitBreakerConfig) {
            this.circuitBreakerConfig = circuitBreakerConfig;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder securityContext(String securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenEndpoint(Service service, Region region) {
            Optional<String> endpoint = region.getEndpoint(service);
            return this.resourcePrincipalTokenEndpoint(endpoint.orElse(null));
        }

        @Deprecated
        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalSessionTokenEndpoint(String resourcePrincipalSessionTokenEndpoint) {
            return (ResourcePrincipalAuthenticationDetailsProviderBuilder)super.federationEndpoint(resourcePrincipalSessionTokenEndpoint);
        }

        @Override
        public ResourcePrincipalAuthenticationDetailsProviderBuilder leafCertificateSupplier(X509CertificateSupplier leafCertificateSupplier) {
            return (ResourcePrincipalAuthenticationDetailsProviderBuilder)super.leafCertificateSupplier(leafCertificateSupplier);
        }

        @Override
        public ResourcePrincipalAuthenticationDetailsProvider build() {
            String ociResourcePrincipalVersion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_VERSION);
            if (ociResourcePrincipalVersion == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION environment variable missing");
            }
            switch (ociResourcePrincipalVersion) {
                case "1.1": {
                    String ociResourcePrincipalRptEndpoint = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT);
                    String ociResourcePrincipalRpstEndpoint = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT);
                    return this.build_1_1(ociResourcePrincipalRptEndpoint, ociResourcePrincipalRpstEndpoint);
                }
                case "2.1": 
                case "2.1.1": {
                    String ociResourcePrincipalRptEndpointFor2_1_or_2_1_1 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT);
                    String ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_or_2_1_1 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT);
                    String ociResourcePrincipalResourceIdForLeafResource = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RESOURCE_ID);
                    String ociResourcePrincipalTenancyIdForLeafResource = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_TENANCY_ID);
                    String ociResourcePrincipalPrivateKeyForLeafResource = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
                    String ociResourcePrincipalPassphraseForLeafResource = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
                    return this.build_2_1_or_2_1_1(ociResourcePrincipalRptEndpointFor2_1_or_2_1_1, ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_or_2_1_1, ociResourcePrincipalResourceIdForLeafResource, ociResourcePrincipalTenancyIdForLeafResource, ociResourcePrincipalPrivateKeyForLeafResource, ociResourcePrincipalPassphraseForLeafResource, ociResourcePrincipalVersion);
                }
                case "2.1.2": {
                    String ociResourcePrincipalRptEndpointFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT);
                    String ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT);
                    String ociResourcePrincipalResourceIdForLeafResourceFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RESOURCE_ID);
                    String ociResourcePrincipalTenancyIdForLeafResourceFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_TENANCY_ID);
                    String ociResourcePrincipalSecurityContext = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_SECURITY_CONTEXT);
                    String ociResourcePrincipalPrivateKeyForLeafResourceFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
                    String ociResourcePrincipalPassphraseForLeafResourceFor2_1_2 = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
                    String ociResourcePrincipalTokenPath = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_PATH);
                    return this.build_2_1_2(ociResourcePrincipalRptEndpointFor2_1_2, ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_2, ociResourcePrincipalTokenPath, ociResourcePrincipalSecurityContext, ociResourcePrincipalResourceIdForLeafResourceFor2_1_2, ociResourcePrincipalTenancyIdForLeafResourceFor2_1_2, ociResourcePrincipalPrivateKeyForLeafResourceFor2_1_2, ociResourcePrincipalPassphraseForLeafResourceFor2_1_2, ociResourcePrincipalVersion);
                }
                case "2.2": {
                    String ociResourcePrincipalPrivateKey = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
                    String ociResourcePrincipalPassphrase = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
                    String ociResourcePrincipalRpst = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST);
                    String ociResourcePrincipalRegion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME);
                    String inputType = "environment variable";
                    return ResourcePrincipalAuthenticationDetailsProviderBuilder.build_2_2(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalRpst, ociResourcePrincipalRegion, "environment variable");
                }
                case "3.0": {
                    return this.build_3_0();
                }
            }
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION has unknown value.\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.");
        }

        public ResourcePrincipalAuthenticationDetailsProvider build_3_0() {
            return ResourcePrincipalsV3AuthenticationDetailsProvider.builder().build();
        }

        public static ResourcePrincipalAuthenticationDetailsProvider build_2_2(String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalRpst, String ociResourcePrincipalRegion, String inputType) {
            SessionKeySupplier sessionKeySupplier = ResourcePrincipalAuthenticationDetailsProvider.getSessionKeySupplierFromPemAndPassphrase(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, inputType);
            FederationClient federationClient = ResourcePrincipalAuthenticationDetailsProvider.getFederationClientFromRpst(ociResourcePrincipalRpst, inputType, sessionKeySupplier);
            Region region = ResourcePrincipalAuthenticationDetailsProvider.getRegion(ociResourcePrincipalRegion, inputType);
            return new ResourcePrincipalAuthenticationDetailsProvider(federationClient, sessionKeySupplier, region);
        }

        public ResourcePrincipalAuthenticationDetailsProvider build_2_1_2(String ociResourcePrincipalRptEndpoint, String ociResourcePrincipalRpstEndpoint, String ociResourcePrincipalTokenPath, String ociSecurityContext, String ociResourcePrincipalResourceId, String ociResourcePrincipalTenancyId, String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalVersion) {
            if (StringUtils.isNotBlank(this.securityContext)) {
                ociSecurityContext = this.securityContext;
                LOG.debug("Security context provided via the builder overrides the value provided via environment variable");
            }
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalRptEndpoint), "required: StringUtils.isNotBlank(resourcePrincipalTokenEndpoint)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalRpstEndpoint), "required: StringUtils.isNotBlank(resourcePrincipalSessionTokenEndpoint)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociSecurityContext), "required: StringUtils.isNotBlank(securityContext)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalResourceId), "required: StringUtils.isNotBlank(resourceId)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalTenancyId), "required: StringUtils.isNotBlank(tenancyId)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalPrivateKey), "required: StringUtils.isNotBlank(ociResourcePrincipalPrivateKey)", new Object[0]);
            if (StringUtils.isBlank(ociResourcePrincipalTokenPath)) {
                ociResourcePrincipalTokenPath = ResourcePrincipalAuthenticationDetailsProvider.DEFAULT_OCI_RESOURCE_PRINCIPAL_RPT_PATH_FORV212;
            }
            String inputType = "environment variable";
            this.sessionKeySupplier = ResourcePrincipalAuthenticationDetailsProvider.getSessionKeySupplierFromPemAndPassphrase(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, "environment variable");
            KeyPairAuthenticationDetailProvider provider = this.getKeyPairAuthenticationDetailProvider(ociResourcePrincipalResourceId, ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalTenancyId, ociResourcePrincipalVersion);
            this.federationClient = new ResourcePrincipalV2FederationClient(ociResourcePrincipalRptEndpoint, ociResourcePrincipalRpstEndpoint, ociResourcePrincipalTokenPath, ociSecurityContext, this.sessionKeySupplier, provider, this.federationClientConfigurator, this.circuitBreakerConfig);
            this.autoDetectEndpointUsingMetadataUrl();
            return new ResourcePrincipalAuthenticationDetailsProvider(this.federationClient, this.sessionKeySupplier, this.region);
        }

        public ResourcePrincipalAuthenticationDetailsProvider build_2_1_or_2_1_1(String ociResourcePrincipalRptEndpoint, String ociResourcePrincipalRpstEndpoint, String ociResourcePrincipalResourceId, String ociResourcePrincipalTenancyId, String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalVersion) {
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalRptEndpoint), "required: StringUtils.isNotBlank(resourcePrincipalTokenEndpoint)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalRpstEndpoint), "required: StringUtils.isNotBlank(resourcePrincipalSessionTokenEndpoint)", new Object[0]);
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalResourceId), "required: StringUtils.isNotBlank(resourceId)", new Object[0]);
            if (ociResourcePrincipalVersion.equals(ResourcePrincipalAuthenticationDetailsProvider.RP_VERSION_2_1_1)) {
                Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalTenancyId), "required: StringUtils.isNotBlank(tenancyId)", new Object[0]);
            }
            Validate.isTrue(StringUtils.isNotBlank(ociResourcePrincipalPrivateKey), "required: StringUtils.isNotBlank(ociResourcePrincipalPrivateKey)", new Object[0]);
            String inputType = "environment variable";
            this.sessionKeySupplier = ResourcePrincipalAuthenticationDetailsProvider.getSessionKeySupplierFromPemAndPassphrase(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, "environment variable");
            KeyPairAuthenticationDetailProvider provider = this.getKeyPairAuthenticationDetailProvider(ociResourcePrincipalResourceId, ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalTenancyId, ociResourcePrincipalVersion);
            this.federationClient = new ResourcePrincipalV2FederationClient(ociResourcePrincipalRptEndpoint, ociResourcePrincipalRpstEndpoint, this.sessionKeySupplier, provider, this.federationClientConfigurator, this.circuitBreakerConfig);
            this.autoDetectEndpointUsingMetadataUrl();
            return new ResourcePrincipalAuthenticationDetailsProvider(this.federationClient, this.sessionKeySupplier, this.region);
        }

        @InternalSdk
        public ResourcePrincipalAuthenticationDetailsProvider build_1_1(String ociResourcePrincipalRptEndpoint, String ociResourcePrincipalRpstEndpoint) {
            this.resourcePrincipalTokenEndpoint = ociResourcePrincipalRptEndpoint;
            this.federationEndpoint = ociResourcePrincipalRpstEndpoint != null ? ociResourcePrincipalRpstEndpoint : this.autoDetectEndpointUsingMetadataUrl();
            this.sessionKeySupplier = new AbstractFederationClientAuthenticationDetailsProviderBuilder.SessionKeySupplierImpl();
            this.federationClient = this.createFederationClient(this.sessionKeySupplier);
            return this.buildProvider(this.sessionKeySupplier);
        }

        private KeyPairAuthenticationDetailProvider getKeyPairAuthenticationDetailProvider(String ociResourcePrincipalResourceId, String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String tenancyId, String ociResourcePrincipalVersion) {
            String passphrase;
            InputStream privateKeyStream;
            if (new File(ociResourcePrincipalPrivateKey).exists()) {
                if (ociResourcePrincipalPassphrase != null && !new File(ociResourcePrincipalPassphrase).exists()) {
                    throw new IllegalArgumentException("Cannot mix path and constant settings for OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + ociResourcePrincipalPrivateKey + " and " + ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE + " " + ociResourcePrincipalPassphrase + ResourcePrincipalAuthenticationDetailsProvider.RP_DEBUG_INFORMATION_LOG);
                }
                try {
                    Path passphrasePath;
                    privateKeyStream = new FileInputStream(ociResourcePrincipalPrivateKey);
                    Path path = passphrasePath = ociResourcePrincipalPassphrase != null ? new File(ociResourcePrincipalPassphrase).toPath() : null;
                    if (passphrasePath != null) {
                        passphrase = new String(Files.readAllBytes(passphrasePath));
                    }
                    passphrase = null;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("Can't find file for private key", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("cannot read the passphrase", e);
                }
            } else {
                passphrase = ociResourcePrincipalPassphrase;
                privateKeyStream = new ByteArrayInputStream(ociResourcePrincipalPrivateKey.getBytes());
            }
            return new KeyPairAuthenticationDetailProvider(ociResourcePrincipalResourceId, privateKeyStream, passphrase != null ? passphrase.toCharArray() : null, tenancyId, ociResourcePrincipalVersion);
        }

        @Override
        protected FederationClient createFederationClient(SessionKeySupplier sessionKeySupplier) {
            this.createRptPathProvider();
            InstancePrincipalsAuthenticationDetailsProvider provider = ((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)InstancePrincipalsAuthenticationDetailsProvider.builder().metadataBaseUrl(this.getMetadataBaseUrl())).federationEndpoint(this.federationEndpoint).leafCertificateSupplier(this.leafCertificateSupplier).intermediateCertificateSuppliers(this.intermediateCertificateSuppliers)).circuitBreakerConfigurator(this.circuitBreakerConfig != null ? this.circuitBreakerConfig : CircuitBreakerUtils.getDefaultCircuitBreakerConfiguration())).federationClientConfigurator(this.federationClientConfigurator)).build();
            return new ResourcePrincipalsFederationClient(this.resourcePrincipalTokenEndpoint, this.resourcePrincipalTokenPathProvider, this.federationEndpoint, sessionKeySupplier, provider, this.federationClientConfigurator, this.circuitBreakerConfig);
        }

        protected void createRptPathProvider() {
            Validate.notNull(this.resourcePrincipalTokenEndpoint, "resourcePrincipalTokenEndpoint must not be null", new Object[0]);
            if (this.resourcePrincipalTokenPathProvider == null) {
                this.resourcePrincipalTokenPathProvider = new DefaultRptPathProvider();
            }
        }

        @Override
        protected ResourcePrincipalAuthenticationDetailsProvider buildProvider(SessionKeySupplier sessionKeySupplierToUse) {
            return new ResourcePrincipalAuthenticationDetailsProvider(this.federationClient, sessionKeySupplierToUse, this.region);
        }
    }

    public static class ClaimKeys {
        public static final String COMPARTMENT_ID_CLAIM_KEY = "res_compartment";
        public static final String TENANT_ID_CLAIM_KEY = "res_tenant";
    }
}

